% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/occ_count.r
\name{occ_count}
\alias{occ_count}
\title{Get number of occurrence records.}
\usage{
occ_count(taxonKey = NULL, georeferenced = NULL, basisOfRecord = NULL,
  datasetKey = NULL, date = NULL, catalogNumber = NULL, country = NULL,
  hostCountry = NULL, year = NULL, from = 2000, to = 2012,
  type = "count", publishingCountry = "US", nubKey = NULL,
  protocol = NULL, ...)
}
\arguments{
\item{taxonKey}{Species key}

\item{georeferenced}{Return only occurence records with lat/long data (TRUE) or
all records (FALSE, default).}

\item{basisOfRecord}{Basis of record}

\item{datasetKey}{Dataset key}

\item{date}{Collection date}

\item{catalogNumber}{Catalog number. PARAMETER GONE.}

\item{country}{Country data was collected in, two letter abbreviation. See
\url{http://countrycode.org/} for abbreviations.}

\item{hostCountry}{Country that hosted the data. PARAMETER GONE.}

\item{year}{Year data were collected in}

\item{from}{Year to start at}

\item{to}{Year to end at}

\item{type}{One of count (default), schema, basis_of_record, countries, or year.}

\item{publishingCountry}{Publishing country, two letter ISO country code}

\item{nubKey}{Species key. PARAMETER NAME CHANGED TO taxonKey.}

\item{protocol}{Protocol. E.g., 'DWC_ARCHIVE'}

\item{...}{Further named parameters, such as \code{query}, \code{path}, etc, passed on to
\code{\link[httr]{modify_url}} within \code{\link[httr]{GET}} call. Unnamed parameters will be
combined with \code{\link[httr]{config}}.}
}
\value{
A single numeric value, or a list of numerics.
}
\description{
Get number of occurrence records.
}
\examples{
\dontrun{
occ_count(basisOfRecord='OBSERVATION')
occ_count(georeferenced=TRUE)
occ_count(country='DE')
occ_count(country='CA', georeferenced=TRUE, basisOfRecord='OBSERVATION')
occ_count(datasetKey='9e7ea106-0bf8-4087-bb61-dfe4f29e0f17')
occ_count(year=2012)
occ_count(taxonKey=2435099)
occ_count(taxonKey=2435099, georeferenced=TRUE)
occ_count(protocol='DWC_ARCHIVE')

# Just schema
occ_count(type='schema')

# Counts by basisOfRecord types
occ_count(type='basisOfRecord')

# Counts by countries. publishingCountry must be supplied (default to US)
occ_count(type='countries')

# Counts by year. from and to years have to be supplied, default to 2000 and 2012
occ_count(type='year', from=2000, to=2012)

# Counts by publishingCountry, must supply a country (default to US)
occ_count(type='publishingCountry')
occ_count(type='publishingCountry', country='BZ')

# Pass on options to httr
library('httr')
res <- occ_count(type='year', from=2000, to=2012, config=progress())
res
}
}
\references{
\url{http://www.gbif.org/developer/occurrence#metrics}
}

