% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/networks.r
\name{networks}
\alias{networks}
\title{Networks metadata.}
\usage{
networks(data = "all", uuid = NULL, query = NULL, identifier = NULL,
  identifierType = NULL, limit = 100, start = NULL, ...)
}
\arguments{
\item{data}{The type of data to get. One or more of: 'contact', 'endpoint',
'identifier', 'tag', 'machineTag', 'comment', 'constituents', or the
special 'all'. Default: \code{'all'}}

\item{uuid}{UUID of the data network provider. This must be specified if data
is anything other than 'all'. Only 1 can be passed in}

\item{query}{Query nodes. Only used when \code{data='all'}. Ignored otherwise.}

\item{identifier}{The value for this parameter can be a simple string or integer,
e.g. identifier=120. This parameter doesn't seem to work right now.}

\item{identifierType}{Used in combination with the identifier parameter to filter
identifiers by identifier type. See details. This parameter doesn't seem to
work right now.}

\item{limit}{Number of records to return. Default: 100. Maximum: 1000.}

\item{start}{Record number to start at. Default: 0. Use in combination with \code{limit} to
page through results.}

\item{...}{Further named parameters, such as \code{query}, \code{path}, etc, passed on to
\code{\link[httr]{modify_url}} within \code{\link[httr]{GET}} call. Unnamed parameters will
be combined with \code{\link[httr]{config}}.}
}
\description{
Networks metadata.
}
\details{
identifierType options:

\itemize{
 \item {DOI} No description.
 \item {FTP} No description.
 \item {GBIF_NODE} Identifies the node (e.g: 'DK' for Denmark, 'sp2000' for Species 2000).
 \item {GBIF_PARTICIPANT} Participant identifier from the GBIF IMS Filemaker system.
 \item {GBIF_PORTAL} Indicates the identifier originated from an auto_increment column in the
 portal.data_provider or portal.data_resource table respectively.
 \item {HANDLER} No description.
 \item {LSID} Reference controlled by a separate system, used for example by DOI.
 \item {SOURCE_ID} No description.
 \item {UNKNOWN} No description.
 \item {URI} No description.
 \item {URL} No description.
 \item {UUID} No description.
}
}
\examples{
\dontrun{
networks(limit=5)
networks(uuid='7ddd1f14-a2b0-4838-95b0-785846f656f3')
uuids <- c('7ddd1f14-a2b0-4838-95b0-785846f656f3', '07b013b4-a2da-47a1-a8ef-df685912fbd6')
lapply(uuids, function(x) networks(uuid = x))
networks(data='endpoint', uuid='16ab5405-6c94-4189-ac71-16ca3b753df7')

# Pass on options to httr
library('httr')
res <- networks(limit=5, config=progress())
}
}
\references{
\url{http://www.gbif.org/developer/registry#networks}
}

