% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/download_queue.R
\name{GbifQueue}
\alias{GbifQueue}
\title{GbifQueue}
\description{
GBIF download queue
}
\examples{
\dontrun{
x <- GbifQueue$new(
  occ_download(pred('taxonKey', 3119195), pred("year", 1976)),
  occ_download(pred('taxonKey', 3119195), pred("year", 2001)),
  occ_download(pred('taxonKey', 3119195), pred("year", 2001), pred("month", 8, "<=")),
  occ_download(pred('taxonKey', 3119195), pred("year", 2004)),
  occ_download(pred('taxonKey', 3119195), pred("year", 2005))
)
x
x$reqs
x$add_all()
x
x$jobs()
x
x$remove(x$reqs[[1]])
x
x$reqs[[1]]$run()
x$reqs[[1]]$result

# pre-prepared download request
z <- occ_download_prep(
  pred_multi("basisOfRecord", c("HUMAN_OBSERVATION","OBSERVATION"), "in"),
  pred("hasCoordinate", TRUE),
  pred("hasGeospatialIssue", FALSE),
  pred("year", 1993),
  user = "foo", pwd = "bar", email = "foo@bar.com"
)
out <- GbifQueue$new(.list = list(z))
out
out$reqs
}
}
\keyword{internal}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{reqs}}{(list) a named list of objects of class \code{\link[=occ_download]{occ_download()}}}

\item{\code{queue}}{(list) holds the queued jobs}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-print}{\code{GbifQueue$print()}}
\item \href{#method-new}{\code{GbifQueue$new()}}
\item \href{#method-add}{\code{GbifQueue$add()}}
\item \href{#method-add_all}{\code{GbifQueue$add_all()}}
\item \href{#method-remove}{\code{GbifQueue$remove()}}
\item \href{#method-next_}{\code{GbifQueue$next_()}}
\item \href{#method-last_}{\code{GbifQueue$last_()}}
\item \href{#method-jobs}{\code{GbifQueue$jobs()}}
\item \href{#method-clone}{\code{GbifQueue$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-print"></a>}}
\subsection{Method \code{print()}}{
print method for the \code{GbifQueue} class
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GbifQueue$print(x, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{self}

\item{\code{...}}{ignored}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\subsection{Method \code{new()}}{
Create a new \code{GbifQueue} object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GbifQueue$new(..., .list = list())}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{any number of \code{\link[=occ_download]{occ_download()}} requests}

\item{\code{.list}}{any number of \code{\link[=occ_download]{occ_download()}} requests as \code{lazy}
objects, called with e.g., \code{lazyeval::lazy()}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new \code{GbifQueue} object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-add"></a>}}
\subsection{Method \code{add()}}{
Add single jobs to the queue
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GbifQueue$add(x)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{an \code{\link[=occ_download]{occ_download()}} object}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
nothing returned; adds job (\code{x}) to the queue
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-add_all"></a>}}
\subsection{Method \code{add_all()}}{
Add all jobs to the queue
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GbifQueue$add_all()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
nothing returned
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-remove"></a>}}
\subsection{Method \code{remove()}}{
Remove a job from the queue
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GbifQueue$remove(x)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{an \code{\link[=occ_download]{occ_download()}} object}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
nothing returned
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-next_"></a>}}
\subsection{Method \code{next_()}}{
Get the next job in the \code{queue}. if no more jobs,
returns empty list
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GbifQueue$next_()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
next job or empty list
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-last_"></a>}}
\subsection{Method \code{last_()}}{
Get the last job in the \code{queue}. if no more jobs,
returns empty list
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GbifQueue$last_()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
last job or empty list
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-jobs"></a>}}
\subsection{Method \code{jobs()}}{
Get number of jobs in the \code{queue}
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GbifQueue$jobs()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
(integer) number of jobs
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GbifQueue$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
