% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/download_queue.R
\name{DownReq}
\alias{DownReq}
\title{DownReq}
\description{
handles single requests for \link{GbifQueue}
}
\examples{
\dontrun{
res <- DownReq$new(occ_download_prep(pred("basisOfRecord", "LITERATURE"), 
  pred("year", "1956")
))
res
# res$run()
# res
# res$status()
# res$result
}
}
\keyword{internal}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{req}}{(list) internal holder for the request}

\item{\code{type}}{(list) type, one of "lazy" (to be lazy evaluated) or "pre"
(run with \code{occ_download_exec} internal fxn)}

\item{\code{result}}{(list) holds the result of the http request}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{DownReq$new()}}
\item \href{#method-print}{\code{DownReq$print()}}
\item \href{#method-run}{\code{DownReq$run()}}
\item \href{#method-status}{\code{DownReq$status()}}
\item \href{#method-clone}{\code{DownReq$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\subsection{Method \code{new()}}{
Create a new \code{DownReq} object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DownReq$new(x)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{either a lazy object with an object of class \code{occ_download}, or an
object of class \code{occ_download_prep}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new \code{DownReq} object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-print"></a>}}
\subsection{Method \code{print()}}{
print method for the \code{DownReq} class
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DownReq$print(x, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{self}

\item{\code{...}}{ignored}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-run"></a>}}
\subsection{Method \code{run()}}{
execute http request
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DownReq$run()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
nothing, puts the http response in \verb{$result}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-status"></a>}}
\subsection{Method \code{status()}}{
check http request status
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DownReq$status()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
output of \code{\link[=occ_download_meta]{occ_download_meta()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DownReq$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
