% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/download_predicate_dsl.R
\name{download_predicate_dsl}
\alias{download_predicate_dsl}
\alias{pred}
\alias{pred_gt}
\alias{pred_gte}
\alias{pred_lt}
\alias{pred_lte}
\alias{pred_not}
\alias{pred_like}
\alias{pred_within}
\alias{pred_isnull}
\alias{pred_notnull}
\alias{pred_or}
\alias{pred_and}
\alias{pred_in}
\alias{pred_default}
\title{Download predicate DSL (domain specific language)}
\usage{
pred(key, value)

pred_gt(key, value)

pred_gte(key, value)

pred_lt(key, value)

pred_lte(key, value)

pred_not(...)

pred_like(key, value)

pred_within(value)

pred_isnull(key)

pred_notnull(key)

pred_or(..., .list = list())

pred_and(..., .list = list())

pred_in(key, value)

pred_default()
}
\arguments{
\item{key}{(character) the key for the predicate. See "Keys" below}

\item{value}{(various) the value for the predicate}

\item{..., .list}{For \code{pred_or()} or \code{pred_and()}, one or more objects of
class \code{occ_predicate}, created by any \verb{pred*} function}
}
\description{
Download predicate DSL (domain specific language)
}
\section{predicate methods and their equivalent types}{


\verb{pred*} functions are named for the 'type' of operation they do, following
the terminology used by GBIF, see
https://www.gbif.org/developer/occurrence#predicates

Function names are given, with the equivalent GBIF type value (e.g.,
\code{pred_gt} and \code{greaterThan})

The following functions take one key and one value:
\itemize{
\item \code{pred}: equals
\item \code{pred_lt}: lessThan
\item \code{pred_lte}: lessThanOrEquals
\item \code{pred_gt}: greaterThan
\item \code{pred_gte}: greaterThanOrEquals
\item \code{pred_like}: like
}

The following function is only for geospatial queries, and only
accepts a WKT string:
\itemize{
\item \code{pred_within}: within
}

The following function is only for stating the you don't want
a key to be null, so only accepts one key:
\itemize{
\item \code{pred_notnull}: isNotNull
}

The following function is only for stating that you want a key to be null.
\itemize{
\item \code{pred_isnull} : isNull
}

The following two functions accept multiple individual predicates,
separating them by either "and" or "or":
\itemize{
\item \code{pred_and}: and
\item \code{pred_or}: or
}

The not predicate accepts one predicate; that is, this negates whatever
predicate is passed in, e.g., not the taxonKey of 12345:
\itemize{
\item \code{pred_not}: not
}

The following function is special in that it accepts a single key
but many values; stating that you want to search for all the values:
\itemize{
\item \code{pred_in}: in
}

The following function will apply commonly used \strong{defaults}.
\itemize{
\item \code{pred_default}
}

Using \code{pred_default()} is equivalent to running:

\if{html}{\out{<div class="sourceCode">}}\preformatted{  pred_and(
   pred("HAS_GEOSPATIAL_ISSUE",FALSE),
   pred("HAS_COORDINATE",TRUE),
   pred("OCCURRENCE_STATUS","PRESENT"),
   pred_not(pred_in("BASIS_OF_RECORD",
    c("FOSSIL_SPECIMEN","LIVING_SPECIMEN")))
  )
}\if{html}{\out{</div>}}
}

\section{What happens internally}{

Internally, the input to \verb{pred*} functions turns into JSON to be sent to
GBIF. For example ...

\code{pred_in("taxonKey", c(2480946, 5229208))} gives:

\if{html}{\out{<div class="sourceCode">}}\preformatted{\{
   "type": "in",
   "key": "TAXON_KEY",
   "values": ["2480946", "5229208"]
 \}
}\if{html}{\out{</div>}}

\code{pred_gt("elevation", 5000)} gives:

\if{html}{\out{<div class="sourceCode">}}\preformatted{\{
   "type": "greaterThan",
   "key": "ELEVATION",
   "value": "5000"
\}
}\if{html}{\out{</div>}}

\code{pred_or(pred("taxonKey", 2977832), pred("taxonKey", 2977901))} gives:

\if{html}{\out{<div class="sourceCode">}}\preformatted{\{
  "type": "or",
  "predicates": [
     \{
       "type": "equals",
       "key": "TAXON_KEY",
       "value": "2977832"
     \},
     \{
       "type": "equals",
       "key": "TAXON_KEY",
       "value": "2977901"
     \}
  ]
\}
}\if{html}{\out{</div>}}
}

\section{Keys}{


Acceptable arguments to the \code{key} parameter are (with the version of
the key in parens that must be sent if you pass the query via the \code{body}
parameter; see below for examples). You can also use the 'ALL_CAPS' version
of a key if you prefer. Open an issue in the GitHub
repository for this package if you know of a key that should
be supported that is not yet.
\itemize{
\item taxonKey (TAXON_KEY)
\item acceptedTaxonKey (ACCEPTED_TAXON_KEY)
\item kingdomKey (KINGDOM_KEY)
\item phylumKey (PHYLUM_KEY)
\item classKey (CLASS_KEY)
\item orderKey (ORDER_KEY)
\item familyKey (FAMILY_KEY)
\item genusKey (GENUS_KEY)
\item subgenusKey (SUBGENUS_KEY)
\item speciesKey (SPECIES_KEY)
\item scientificName (SCIENTIFIC_NAME)
\item country (COUNTRY)
\item publishingCountry (PUBLISHING_COUNTRY)
\item hasCoordinate (HAS_COORDINATE)
\item hasGeospatialIssue (HAS_GEOSPATIAL_ISSUE)
\item typeStatus (TYPE_STATUS)
\item recordNumber (RECORD_NUMBER)
\item lastInterpreted (LAST_INTERPRETED)
\item modified (MODIFIED)
\item continent (CONTINENT)
\item geometry (GEOMETRY)
\item basisOfRecord (BASIS_OF_RECORD)
\item datasetKey (DATASET_KEY)
\item datasetID/datasetId (DATASET_ID)
\item eventDate (EVENT_DATE)
\item catalogNumber (CATALOG_NUMBER)
\item otherCatalogNumbers (OTHER_CATALOG_NUMBERS)
\item year (YEAR)
\item month (MONTH)
\item decimalLatitude (DECIMAL_LATITUDE)
\item decimalLongitude (DECIMAL_LONGITUDE)
\item elevation (ELEVATION)
\item depth (DEPTH)
\item institutionCode (INSTITUTION_CODE)
\item collectionCode (COLLECTION_CODE)
\item issue (ISSUE)
\item mediatype (MEDIA_TYPE)
\item recordedBy (RECORDED_BY)
\item recordedById/recordedByID (RECORDED_BY_ID)
\item establishmentMeans (ESTABLISHMENT_MEANS)
\item coordinateUncertaintyInMeters (COORDINATE_UNCERTAINTY_IN_METERS)
\item gadm (GADM_GID) (for the Database of Global Administrative Areas)
\item level0Gid (GADM_LEVEL_0_GID)
\item level1Gid (GADM_LEVEL_1_GID)
\item level2Gid (GADM_LEVEL_2_GID)
\item level3Gid (GADM_LEVEL_3_GID)
\item stateProvince (STATE_PROVINCE)
\item occurrenceStatus (OCCURRENCE_STATUS)
\item publishingOrg (PUBLISHING_ORG)
\item occurrenceId/occurrenceID (OCCURRENCE_ID)
\item eventId/eventID (EVENT_ID)
\item parentEventId/parentEventID (PARENT_EVENT_ID)
\item identifiedBy (IDENTIFIED_BY)
\item identifiedById/identifiedByID (IDENTIFIED_BY_ID)
\item license (LICENSE)
\item locality(LOCALITY)
\item pathway (PATHWAY)
\item preparations (PREPARATIONS)
\item networkKey (NETWORK_KEY)
\item organismId/organismID (ORGANISM_ID)
\item organismQuantity (ORGANISM_QUANTITY)
\item organismQuantityType (ORGANISM_QUANTITY_TYPE)
\item protocol (PROTOCOL)
\item relativeOrganismQuantity (RELATIVE_ORGANISM_QUANTITY)
\item repatriated (REPATRIATED)
\item sampleSizeUnit (SAMPLE_SIZE_UNIT)
\item sampleSizeValue (SAMPLE_SIZE_VALUE)
\item samplingProtocol (SAMPLING_PROTOCOL)
\item verbatimScientificName (VERBATIM_SCIENTIFIC_NAME)
\item taxonID/taxonId (TAXON_ID)
\item taxonomicStatus (TAXONOMIC_STATUS)
\item waterBody (WATER_BODY)
\item iucnRedListCategory (IUCN_RED_LIST_CATEGORY)
\item degreeOfEstablishment (DEGREE_OF_ESTABLISHMENT)
\item isInCluster (IS_IN_CLUSTER)
\item lifeStage (LIFE_STAGE)
\item distanceFromCentroidInMeters (DISTANCE_FROM_CENTROID_IN_METERS)
\item gbifId (GBIF_ID)
}
}

\examples{
pred("taxonKey", 3119195)
pred_gt("elevation", 5000)
pred_gte("elevation", 5000)
pred_lt("elevation", 1000)
pred_lte("elevation", 1000)
pred_within("POLYGON((-14 42, 9 38, -7 26, -14 42))")
pred_and(pred_within("POLYGON((-14 42, 9 38, -7 26, -14 42))"),
  pred_gte("elevation", 5000))
pred_or(pred_lte("year", 1989), pred("year", 2000))
pred_and(pred_lte("year", 1989), pred("year", 2000))
pred_in("taxonKey", c(2977832, 2977901, 2977966, 2977835))
pred_in("basisOfRecord", c("MACHINE_OBSERVATION", "HUMAN_OBSERVATION"))
pred_not(pred("taxonKey", 729))
pred_like("catalogNumber", "PAPS5-560\%")
pred_notnull("issue")
pred("basisOfRecord", "LITERATURE")
pred("hasCoordinate", TRUE)
pred("stateProvince", "California")
pred("hasGeospatialIssue", FALSE)
pred_within("POLYGON((-14 42, 9 38, -7 26, -14 42))")
pred_or(pred("taxonKey", 2977832), pred("taxonKey", 2977901),
  pred("taxonKey", 2977966))
pred_in("taxonKey", c(2977832, 2977901, 2977966, 2977835))
}
\references{
Download predicates docs:
\url{https://www.gbif.org/developer/occurrence#predicates}
}
\seealso{
Other downloads: 
\code{\link{occ_download_cached}()},
\code{\link{occ_download_cancel}()},
\code{\link{occ_download_dataset_activity}()},
\code{\link{occ_download_datasets}()},
\code{\link{occ_download_get}()},
\code{\link{occ_download_import}()},
\code{\link{occ_download_list}()},
\code{\link{occ_download_meta}()},
\code{\link{occ_download_queue}()},
\code{\link{occ_download_wait}()},
\code{\link{occ_download}()}
}
\concept{downloads}
