% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataset.R
\name{dataset}
\alias{dataset}
\title{Search for more obscure dataset metadata.}
\usage{
dataset(
  country = NULL,
  type = NULL,
  identifierType = NULL,
  identifier = NULL,
  machineTagNamespace = NULL,
  machineTagName = NULL,
  machineTagValue = NULL,
  modified = NULL,
  query = NULL,
  deleted = FALSE,
  limit = NULL,
  start = NULL,
  curlopts = list()
)
}
\arguments{
\item{country}{The 2-letter country code (as per ISO-3166-1) of the country
publishing the dataset.}

\item{type}{The primary type of the dataset.
Available values : OCCURRENCE, CHECKLIST, METADATA, SAMPLING_EVENT,
MATERIAL_ENTITY.}

\item{identifierType}{An identifier type for the identifier parameter.
Available values : URL, LSID, HANDLER, DOI, UUID, FTP, URI, UNKNOWN,
GBIF_PORTAL, GBIF_NODE, GBIF_PARTICIPANT, GRSCICOLL_ID, GRSCICOLL_URI,
IH_IRN, ROR, GRID, CITES, SYMBIOTA_UUID, WIKIDATA, NCBI_BIOCOLLECTION.}

\item{identifier}{An identifier of the type given by the identifierType
parameter.}

\item{machineTagNamespace}{Filters for entities with a machine tag in the
specified namespace.}

\item{machineTagName}{Filters for entities with a machine tag with the
specified name (use in combination with the machineTagNamespace parameter).}

\item{machineTagValue}{Filters for entities with a machine tag with the
specified value (use in combination with the machineTagNamespace and machineTagName parameters).}

\item{modified}{The modified date of the dataset. Accepts ranges and a ''
can be used as a wildcard, e.g.:modified=2023-04-01,}

\item{query}{Simple full text search parameter. The value for this parameter
can be a simple word or a phrase. Wildcards are not supported.}

\item{deleted}{Logical specifying whether to return only deleted datasets.}

\item{limit}{Controls the number of results in the page.}

\item{start}{Determines the start for the search results.}

\item{curlopts}{options passed on to \link[crul:HttpClient]{crul::HttpClient}.}
}
\value{
A \code{list}.
}
\description{
Search for more obscure dataset metadata.
}
\details{
This function allows you to search for some more obscure dataset metadata
that might not be possible with \code{dataset_search()}. For example, searching
through registry machinetags.
}
\examples{
\dontrun{
dataset(limit=3)
dataset(country="US",limit=3)
dataset(type="CHECKLIST",limit=3)
dataset(identifierType = "URL",limit=3)
dataset(identifier = 168,limit=3)
dataset(machineTagNamespace = "metasync.gbif.org",limit=3)
dataset(machineTagName = "datasetTitle",limit=3)
dataset(machineTagValue = "Borkhart",limit=3)
dataset(modified = "2023-04-01", limit=3) 
dataset(q = "dog", limit=3) 
dataset(deleted=TRUE,limit=3)
}
}
