% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/name_lookup.r
\name{name_lookup}
\alias{name_lookup}
\title{Lookup names in all taxonomies in GBIF.}
\usage{
name_lookup(
  query = NULL,
  rank = NULL,
  higherTaxonKey = NULL,
  status = NULL,
  isExtinct = NULL,
  habitat = NULL,
  nameType = NULL,
  datasetKey = NULL,
  origin = NULL,
  nomenclaturalStatus = NULL,
  limit = 100,
  start = 0,
  facet = NULL,
  facetMincount = NULL,
  facetMultiselect = NULL,
  type = NULL,
  hl = NULL,
  issue = NULL,
  constituentKey = NULL,
  verbose = FALSE,
  return = NULL,
  curlopts = list()
)
}
\arguments{
\item{query}{Query term(s) for full text search.}

\item{rank}{CLASS, CULTIVAR, CULTIVAR_GROUP, DOMAIN, FAMILY, FORM, GENUS,
INFORMAL, INFRAGENERIC_NAME, INFRAORDER, INFRASPECIFIC_NAME,
INFRASUBSPECIFIC_NAME, KINGDOM, ORDER, PHYLUM, SECTION, SERIES, SPECIES,
STRAIN, SUBCLASS, SUBFAMILY, SUBFORM, SUBGENUS, SUBKINGDOM, SUBORDER,
SUBPHYLUM, SUBSECTION, SUBSERIES, SUBSPECIES, SUBTRIBE, SUBVARIETY,
SUPERCLASS, SUPERFAMILY, SUPERORDER, SUPERPHYLUM, SUPRAGENERIC_NAME,
TRIBE, UNRANKED, VARIETY}

\item{higherTaxonKey}{Filters by any of the higher Linnean rank keys. Note
this is within the respective checklist and not searching nub keys
across all checklists. This parameter accepts many inputs in a vector (
passed in the same request).}

\item{status}{Filters by the taxonomic status as one of:
\itemize{
\item ACCEPTED
\item DETERMINATION_SYNONYM Used for unknown child taxa referred to via
spec, ssp, ...
\item DOUBTFUL Treated as accepted, but doubtful whether this is correct.
\item HETEROTYPIC_SYNONYM More specific subclass of SYNONYM.
\item HOMOTYPIC_SYNONYM More specific subclass of SYNONYM.
\item INTERMEDIATE_RANK_SYNONYM Used in nub only.
\item MISAPPLIED More specific subclass of SYNONYM.
\item PROPARTE_SYNONYM More specific subclass of SYNONYM.
\item SYNONYM A general synonym, the exact type is unknown.
}}

\item{isExtinct}{(logical) Filters by extinction status (e.g.
\code{isExtinct=TRUE})}

\item{habitat}{(character) Filters by habitat. One of: marine, freshwater,
or terrestrial}

\item{nameType}{Filters by the name type as one of:
\itemize{
\item BLACKLISTED surely not a scientific name.
\item CANDIDATUS Candidatus is a component of the taxonomic name for a
bacterium that cannot be maintained in a Bacteriology Culture Collection.
\item CULTIVAR a cultivated plant name.
\item DOUBTFUL doubtful whether this is a scientific name at all.
\item HYBRID a hybrid formula (not a hybrid name).
\item INFORMAL a scientific name with some informal addition like "cf." or
indetermined like Abies spec.
\item SCINAME a scientific name which is not well formed.
\item VIRUS a virus name.
\item WELLFORMED a well formed scientific name according to present
nomenclatural rules.
}}

\item{datasetKey}{Filters by the dataset's key (a uuid)}

\item{origin}{(character) Filters by origin. One of:
\itemize{
\item SOURCE
\item DENORMED_CLASSIFICATION
\item VERBATIM_ACCEPTED
\item EX_AUTHOR_SYNONYM
\item AUTONYM
\item BASIONYM_PLACEHOLDER
\item MISSING_ACCEPTED
\item IMPLICIT_NAME
\item PROPARTE
\item VERBATIM_BASIONYM
}}

\item{nomenclaturalStatus}{Not yet implemented, but will eventually allow
for filtering by a nomenclatural status enum.}

\item{limit}{Number of records to return.
Hard maximum limit set by GBIF API: 99999.}

\item{start}{Record number to start at. Default: 0.}

\item{facet}{A vector/list of facet names used to retrieve the 100 most
frequent values for a field. Allowed facets are: datasetKey, higherTaxonKey,
rank, status, isExtinct, habitat, and nameType. Additionally threat and
nomenclaturalStatus are legal values but not yet implemented, so data will
not yet be returned for them.}

\item{facetMincount}{Used in combination with the facet parameter. Set
facetMincount to exclude facets with a count less than x, e.g.
http://bit.ly/2osAUQB only shows the type values 'CHECKLIST' and 'OCCURRENCE'
because the other types have counts less than 10000}

\item{facetMultiselect}{(logical) Used in combination with the facet
parameter. Set \code{facetMultiselect=TRUE} to still return counts for
values that are not currently filtered, e.g. http://bit.ly/2JAymaC still
shows all type values even though type is being filtered
by \code{type=CHECKLIST}.}

\item{type}{Type of name. One of occurrence, checklist, or metadata.}

\item{hl}{(logical) Set \code{hl=TRUE} to highlight terms matching the query
when in fulltext search fields. The highlight will be an emphasis tag of
class \code{gbifH1} e.g. \code{query='plant', hl=TRUE}. Fulltext search
fields include: title, keyword, country, publishing country, publishing
organization title, hosting organization title, and description. One
additional full text field is searched which includes information from
metadata documents, but the text of this field is not returned in the
response.}

\item{issue}{Filters by issue. Issue has to be related to names. Type
\code{gbif_issues()} to get complete list of issues.}

\item{constituentKey}{Filters by the dataset's constituent key (a uuid).}

\item{verbose}{(logical) If \code{TRUE}, all data is returned as a list for each
element. If \code{FALSE} (default) a subset of the data that is thought to be most
essential is organized into a data.frame.}

\item{return}{Defunct. All components are returned; index to the
one(s) you want}

\item{curlopts}{list of named curl options passed on to
\code{\link[crul]{HttpClient}}. see \code{curl::curl_options}
for curl options}
}
\value{
An object of class gbif, which is a S3 class list, with slots for
metadata (\code{meta}), the data itself (\code{data}), the taxonomic
hierarchy data (\code{hierarchies}), and vernacular names (\code{names}).
In addition, the object has attributes listing the user supplied arguments
and type of search, which is, differently from occurrence data, always
equals to 'single' even if multiple values for some parameters are given.
\code{meta} is a list of length four with offset, limit, endOfRecords and
count fields. \code{data} is a tibble (aka data.frame) containing all
information about the found taxa. \code{hierarchies} is a list of
data.frame's, one per GBIF key (taxon), containing its taxonomic
classification. Each data.frame contains two columns: \code{rankkey} and
\code{name}. \code{names} returns a list of data.frame's, one per GBIF key
(taxon), containing all vernacular names. Each data.frame contains two
columns: \code{vernacularName} and \code{language}.

A list of length five:
\itemize{
\item \strong{metadata}
\item \strong{data}: either a data.frame (\code{verbose=FALSE}, default) or a list (\code{verbose=TRUE}).
\item \strong{facets}
\item \strong{hierarchies}
\item \strong{names}
}
}
\description{
This service uses fuzzy lookup so that you can put in partial names and
you should get back those things that match. See examples below.

Faceting: If \code{facet=FALSE} or left to the default (NULL), no faceting
is done. And therefore, all parameters with facet in their name are
ignored (facetOnly, facetMincount, facetMultiselect).
}
\section{Repeat parameter inputs}{

Some parameters can take many inputs, and treated as 'OR' (e.g., a or b or
c). The following take many inputs:
\itemize{
\item \strong{rank}
\item \strong{higherTaxonKey}
\item \strong{status}
\item \strong{habitat}
\item \strong{nameType}
\item \strong{datasetKey}
\item \strong{origin}
}
}

\examples{
\dontrun{
# Look up names like mammalia
name_lookup(query='mammalia', limit = 20)

# Start with an offset
name_lookup(query='mammalia', limit=1)
name_lookup(query='mammalia', limit=1, start=2)

# large requests (paging is internally implemented).
# hard maximum limit set by GBIF API: 99999
# name_lookup(query = "Carnivora", limit = 10000)

# Get all data and parse it, removing descriptions which can be quite long
out <- name_lookup('Helianthus annuus', rank="species", verbose=TRUE)
lapply(out$data, function(x) {
  x[!names(x) \%in\% c("descriptions","descriptionsSerialized")]
})

# Search for a genus
name_lookup(query="Cnaemidophorus", rank="genus")
# Limit records to certain number
name_lookup('Helianthus annuus', rank="species", limit=2)

# Query by habitat
name_lookup(habitat = "terrestrial", limit=2)
name_lookup(habitat = "marine", limit=2)
name_lookup(habitat = "freshwater", limit=2)

# Using faceting
name_lookup(facet='status', limit=0, facetMincount='70000')
name_lookup(facet=c('status','higherTaxonKey'), limit=0,
  facetMincount='700000')

name_lookup(facet='nameType', limit=0)
name_lookup(facet='habitat', limit=0)
name_lookup(facet='datasetKey', limit=0)
name_lookup(facet='rank', limit=0)
name_lookup(facet='isExtinct', limit=0)

name_lookup(isExtinct=TRUE, limit=0)

# text highlighting
## turn on highlighting
res <- name_lookup(query='canada', hl=TRUE, limit=5)
res$data
name_lookup(query='canada', hl=TRUE, limit=45)
## and you can pass the output to gbif_names() function
res <- name_lookup(query='canada', hl=TRUE, limit=5)
gbif_names(res)

# Lookup by datasetKey (set up sufficient high limit, API maximum: 99999)
# name_lookup(datasetKey='3f8a1297-3259-4700-91fc-acc4170b27ce',
#   limit = 50000)

# Some parameters accept many inputs, treated as OR
name_lookup(rank = c("family", "genus"))
name_lookup(higherTaxonKey = c("119", "120", "121", "204"))
name_lookup(status = c("misapplied", "synonym"))$data
name_lookup(habitat = c("marine", "terrestrial"))
name_lookup(nameType = c("cultivar", "doubtful"))
name_lookup(datasetKey = c("73605f3a-af85-4ade-bbc5-522bfb90d847",
  "d7c60346-44b6-400d-ba27-8d3fbeffc8a5"))
name_lookup(datasetKey = "289244ee-e1c1-49aa-b2d7-d379391ce265",
  origin = c("SOURCE", "DENORMED_CLASSIFICATION"))

# Pass on curl options
name_lookup(query='Cnaemidophorus', rank="genus",
  curlopts = list(verbose = TRUE))
}
}
\references{
\url{https://www.gbif.org/developer/species#searching}
}
