% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/export.R
\name{gd_export}
\alias{gd_export}
\title{Export image to Earth Engine Asset, Google Cloud Storage Bucket, or Google Drive}
\usage{
gd_export(
  x,
  filename,
  type = "drive",
  folder = dirname(filename),
  region,
  wait = TRUE,
  ...
)
}
\arguments{
\item{x}{An object that inherits from \code{geedim.download.BaseImage}}

\item{filename}{Output filename. If \code{type} is \code{"asset"} and \code{folder} is not specified, \code{filename} should be a valid Earth Engine asset ID.}

\item{type}{Export type. Defaults to \code{"drive"}; other options include \code{"asset"}, and "\code{cloud}". See \code{gd_export_types()}}

\item{folder}{Destination folder. Defaults to \code{dirname(filename)}.}

\item{region}{Region e.g. from \code{gd_bbox()} or \code{gd_region()}}

\item{wait}{Wait for completion? Default: \code{TRUE}}

\item{...}{Additional arguments to \code{geedim.download.BaseImage.export()}}
}
\value{
an \code{ee.batch.Task} object
}
\description{
Exports an encapsulated image to the destination specified by \code{type}, \code{folder} and \code{filename}
}
\details{
See the \href{https://geedim.readthedocs.io/en/latest/_generated/geedim.mask.MaskedImage.export.html}{geedim.mask.MaskedImage.export() documentation} for details on additional arguments. Requires 'geedim' >1.6.0.
}
\examples{
\dontrun{
if (gd_is_initialized()) {
 r <- gd_bbox(
   xmin = -120.6032,
   xmax = -120.5377,
   ymin = 38.0807,
   ymax = 38.1043
 )

 i <- gd_image_from_id('CSP/ERGo/1_0/US/CHILI')

 ## export to Google Drive (default `type="drive"`)
 # res <- gd_export(i, filename = "RGEEDIM_TEST.tif", scale = 100, region = r)

 ## export to `type="asset"`, then download by ID (stored in project assets)
 # res <- gd_export(
 #   i,
 #   "RGEEDIM_TEST",
 #   type = "asset",
 #   folder = "your-project-name",
 #   scale = 100,
 #   region = r
 # )
 # gd_download("projects/your-project-name/assets/RGEEDIM_TEST", filename = "test.tif")

 ## export to Google Cloud Bucket with `type="cloud"`,
 ##   where `folder` is the bucket path without `"gs://"`
 # res <- gd_export(i, filename = "RGEEDIM_TEST.tif", type = "cloud",
 #                  folder = "your-bucket-name", scale = 100, region = r)
}
}
}
