% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/genie_functions.R
\name{get_variance_components}
\alias{get_variance_components}
\title{Performs a variance components estimate for each deletion allele based on
the replicate metadata provided.}
\usage{
get_variance_components(
  del_result,
  replicates,
  allele_min_reads = 100,
  allele_min_fraction = 0.001
)
}
\arguments{
\item{del_result}{The result from deletion_analysis}

\item{replicates}{A data.frame defining GenIE replicate metadata.}

\item{allele_min_reads}{The minimum number of reads that a deletion allele must have across all replicates to be included.}

\item{allele_min_fraction}{The minimum fraction of total reads that a deletion allele must have across all replications to be included.}
}
\value{
Returns a list with tables vp_cDNA and vp_gDNA, which partition variance according to the metadata columns that begin with "replicate_" in the 'replicates' parameter.
}
\description{
Performs a variance components estimate for each deletion allele based on
the replicate metadata provided.
}
\examples{
\donttest{
# Note: First run deletion_analysis()
# The below isn't run since it can take 10+ seconds to run
# mul1_del_results is a pre-loaded result

vc = get_variance_components(mul1_del_results[[1]], mul1_replicates)
variance_components_plot(vc)
}
}
\seealso{
\code{\link{deletion_analysis}}

\code{\link{variance_components_plot}}
}
