% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/weights.R
\name{get_neighbors_weights}
\alias{get_neighbors_weights}
\title{Weights values of the neighbors of one observation}
\usage{
get_neighbors_weights(gda_w, idx)
}
\arguments{
\item{gda_w}{A Weight object}

\item{idx}{A value indicates idx-th observation, idx start from 1}
}
\value{
A numeric vector of the neighbor indices, which start from 1
}
\description{
Get the associated weights values of neighbors for idx-th
observation
}
\examples{
\dontrun{
guerry_path <- system.file("extdata", "Guerry.shp", package = "rgeoda")
guerry <- st_read(guerry_path)
queen_w <- queen_weights(guerry)
nbrs <- get_neighbors_weights(queen_w, idx = 1)
cat("\nNeighbors of the 1-st observation are:", nbrs)
}
}
