% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rgexf-package.R
\docType{package}
\name{rgexf-package}
\alias{rgexf-package}
\alias{rgexf}
\alias{gephi}
\title{Build, Import and Export GEXF Graph Files}
\description{
Create, read and write GEXF (Graph Exchange XML Format) graph files (used in
Gephi and others).
}
\details{
Using the XML package, it allows the user to easily build/read graph files
including attributes, GEXF viz attributes (such as color, size, and
position), network dynamics (for both edges and nodes) and edge weighting.

Users can build/handle graphs element-by-element or massively through
data-frames, visualize the graph on a web browser through "gexf-js" (a
javascript library) and interact with the igraph package.

Finally, the functions \code{igraph.to.gexf} and \code{gexf.to.igraph}
convert objects from \code{igraph} to \code{gexf} and viceversa keeping
attributes and colors.

Please visit the project home for more information:
\url{https://github.com/gvegayon/rgexf}.
}
\note{
See the GEXF primer for details on the GEXF graph format:
\url{https://gephi.org/gexf/1.2draft/gexf-12draft-primer.pdf}
}
\examples{

if (interactive()) {
    demo(gexf) # Example of gexf command using fictional data.
    demo(gexfattributes) # Working with attributes.
    demo(gexfbasic) # Basic net.
    demo(gexfdynamic) # Dynamic net.
    demo(edge.list) # Working with edges lists.
    demo(gexffull) # All the package.
    demo(gexftwitter) # Example with real data of chilean twitter accounts.
    demo(gexfdynamicandatt) # Dynamic net with static attributes.
    demo(gexfbuildfromscratch) # Example building a net from scratch.
    demo(gexfigraph) # Two-way gexf-igraph conversion
    demo(gexfrandom) # A nice routine creating a good looking graph
}

}
\references{
\itemize{ \item rgexf project site:
\url{https://github.com/gvegayon/rgexf} \item Gephi project site:
\url{https://gephi.org/} \item GEXF project site: \url{https://gephi.org/gexf/format//}
\item gexf-js project website: \url{https://github.com/raphv/gexf-js}
\item Sigmasj project site: \url{http://sigmajs.org/}
}
}
\keyword{package}
