% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_data.R
\name{get_gho_data_}
\alias{get_gho_data}
\alias{get_gho_data_}
\title{Returns GHO Data}
\usage{
get_gho_data_(code, dimension = "GHO", filter = NULL, ...)

get_gho_data(code, dimension = "GHO", filter = NULL, ...)
}
\arguments{
\item{code}{A GHO code.}

\item{dimension}{A GHO dimension.}

\item{filter}{A named list of filtering parameters (see details).}

\item{...}{Additional query parameters (see details).}
}
\value{
A \code{data_frame}.
}
\description{
Given a dimension and a code, returns the corresponding GHO data.
}
\details{
Filtering parameters are given as a named list of the form
\code{list(COUNTRY = "FRA", ...)}.

Query parameters follow the specification described on the WHO website
\url{http://apps.who.int/gho/data/node.resources.api}.
}
\examples{

result <- get_gho_data(
  dimension = "GHO",
  code = "MDG_0000000001"
)
print(result, width = Inf)


result <- get_gho_data(
  dimension = "GHO",
  code = "MDG_0000000001",
  filter = list(
    REGION = "EUR",
    YEAR = "2015"
  )
)
print(result, width = Inf)

}

