% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/from_digraph6.R
\name{from_digraph6}
\alias{from_digraph6}
\alias{adjacency_from_digraph6}
\alias{igraph_from_digraph6}
\alias{network_from_digraph6}
\title{Parsing \code{digraph6} symbols}
\usage{
adjacency_from_digraph6(d6)

igraph_from_digraph6(d6, ...)

network_from_digraph6(d6, ...)
}
\arguments{
\item{d6}{character vector of 'digraph6' symbols}

\item{...}{other arguments, see Details.}
}
\value{
The returned object is:

\itemize{
\item for \code{\link[=adjacency_from_digraph6]{adjacency_from_digraph6()}}, a list of the same length as
its input of square symmetric adjacency matrices.
}

\itemize{
\item for \code{\link[=igraph_from_digraph6]{igraph_from_digraph6()}}, a list of 'igraph' objects
}

\itemize{
\item for \code{\link[=network_from_digraph6]{network_from_digraph6()}}, a list of 'network' objects
}
}
\description{
These functions take a vector of 'digraph6' symbols and return a
list of other types of objects:

\itemize{
\item \code{\link[=adjacency_from_digraph6]{adjacency_from_digraph6()}} creates adjacency matrices
}

\itemize{
\item \code{\link[=igraph_from_digraph6]{igraph_from_digraph6()}} creates 'igraph' objects. Requires
package \pkg{igraph} to be installed.
}

\itemize{
\item \code{\link[=network_from_digraph6]{network_from_digraph6()}} creates 'network' objects. Requires
package \pkg{network} to be installed.
}
}
\details{
For \code{\link[=igraph_from_digraph6]{igraph_from_digraph6()}} additional arguments are passed to
\code{\link[igraph:graph_from_adjacency_matrix]{igraph::graph_from_adjacency_matrix()}}

For \code{\link[=network_from_digraph6]{network_from_digraph6()}} additional arguments are passed to
\code{\link[network:network]{network::as.network()}}
}
\examples{
am <- matrix(rbinom(16, 1, 0.3), 4, 4)
d6 <- as_digraph6(am)

# To adjacency matrix ------------------------------------------------------
adjacency_from_digraph6(d6)

# To igraph objects --------------------------------------------------------
if(requireNamespace("igraph", quietly=TRUE)) {
  igraph_from_digraph6(d6)
}

# To network objects -------------------------------------------------------
if(requireNamespace("network", quietly=TRUE)) {
  network_from_digraph6(d6)
}
}
\seealso{
\code{\link[=as_digraph6]{as_digraph6()}} for encoding objects as 'digraph6' symbols.
}
