% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/complex-cubical.R
\name{CubicalComplex}
\alias{CubicalComplex}
\title{R6 Class for Cubical Complex}
\description{
The CubicalComplex is an example of a structured complex useful
in computational mathematics (specially rigorous numerics) and image
analysis.
}
\examples{
\dontshow{if (reticulate::py_module_available("gudhi")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
n <- 10
X <- cbind(seq(0, 1, len = n), seq(0, 1, len = n))
cc <- CubicalComplex$new(top_dimensional_cells = X)
cc
\dontshow{\}) # examplesIf}
\dontshow{if (reticulate::py_module_available("gudhi")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
n <- 10
X <- cbind(seq(0, 1, len = n), seq(0, 1, len = n))
cc <- CubicalComplex$new(top_dimensional_cells = X)
cc$compute_persistence()$betti_numbers()
\dontshow{\}) # examplesIf}
\dontshow{if (reticulate::py_module_available("gudhi")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
n <- 10
X <- cbind(seq(0, 1, len = n), seq(0, 1, len = n))
cc <- CubicalComplex$new(top_dimensional_cells = X)
cc$compute_persistence()$cofaces_of_persistence_pairs()
\dontshow{\}) # examplesIf}
\dontshow{if (reticulate::py_module_available("gudhi")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
n <- 10
X <- cbind(seq(0, 1, len = n), seq(0, 1, len = n))
cc <- CubicalComplex$new(top_dimensional_cells = X)
cc$dimension()
\dontshow{\}) # examplesIf}
\dontshow{if (reticulate::py_module_available("gudhi")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
n <- 10
X <- cbind(seq(0, 1, len = n), seq(0, 1, len = n))
cc <- CubicalComplex$new(top_dimensional_cells = X)
cc$num_simplices()
\dontshow{\}) # examplesIf}
\dontshow{if (reticulate::py_module_available("gudhi")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
n <- 10
X <- cbind(seq(0, 1, len = n), seq(0, 1, len = n))
cc <- CubicalComplex$new(top_dimensional_cells = X)
cc$persistence()
\dontshow{\}) # examplesIf}
\dontshow{if (reticulate::py_module_available("gudhi")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
n <- 10
X <- cbind(seq(0, 1, len = n), seq(0, 1, len = n))
cc <- CubicalComplex$new(top_dimensional_cells = X)
cc$compute_persistence()$persistence_intervals_in_dimension(0)
\dontshow{\}) # examplesIf}
\dontshow{if (reticulate::py_module_available("gudhi")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
n <- 10
X <- cbind(seq(0, 1, len = n), seq(0, 1, len = n))
cc <- CubicalComplex$new(top_dimensional_cells = X)
cc$compute_persistence()$persistent_betti_numbers(0, 1)
\dontshow{\}) # examplesIf}
}
\seealso{
Other data structures for cell complexes: 
\code{\link{PeriodicCubicalComplex}},
\code{\link{SimplexTree}}
}
\author{
Pawel Dlotko
}
\concept{data structures for cell complexes}
\section{Super class}{
\code{rgudhi::PythonClass} -> \code{CubicalComplex}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-CubicalComplex-new}{\code{CubicalComplex$new()}}
\item \href{#method-CubicalComplex-betti_numbers}{\code{CubicalComplex$betti_numbers()}}
\item \href{#method-CubicalComplex-cofaces_of_persistence_pairs}{\code{CubicalComplex$cofaces_of_persistence_pairs()}}
\item \href{#method-CubicalComplex-compute_persistence}{\code{CubicalComplex$compute_persistence()}}
\item \href{#method-CubicalComplex-dimension}{\code{CubicalComplex$dimension()}}
\item \href{#method-CubicalComplex-num_simplices}{\code{CubicalComplex$num_simplices()}}
\item \href{#method-CubicalComplex-persistence}{\code{CubicalComplex$persistence()}}
\item \href{#method-CubicalComplex-persistence_intervals_in_dimension}{\code{CubicalComplex$persistence_intervals_in_dimension()}}
\item \href{#method-CubicalComplex-persistent_betti_numbers}{\code{CubicalComplex$persistent_betti_numbers()}}
\item \href{#method-CubicalComplex-clone}{\code{CubicalComplex$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="rgudhi" data-topic="PythonClass" data-id="get_python_class"><a href='../../rgudhi/html/PythonClass.html#method-PythonClass-get_python_class'><code>rgudhi::PythonClass$get_python_class()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgudhi" data-topic="PythonClass" data-id="set_python_class"><a href='../../rgudhi/html/PythonClass.html#method-PythonClass-set_python_class'><code>rgudhi::PythonClass$set_python_class()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CubicalComplex-new"></a>}}
\if{latex}{\out{\hypertarget{method-CubicalComplex-new}{}}}
\subsection{Method \code{new()}}{
Constructor from either \code{top_dimensional_cells} (and
possibly \code{dimensions}) or from a Perseus-style file name.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CubicalComplex$new(
  perseus_file,
  top_dimensional_cells,
  dimensions = NULL,
  py_class = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{perseus_file}}{A character string specifying the path to a
Perseus-style file name.}

\item{\code{top_dimensional_cells}}{Either a numeric vector (in which case,
\code{dimensions} should be provided as well) or a multidimensional array
specifying cell filtration values.}

\item{\code{dimensions}}{An integer vector specifying the number of top
dimensional cells. Defaults to \code{NULL}.}

\item{\code{py_class}}{An existing \code{CubicalComplex} Python class. Defaults to
\code{NULL} which uses the Python class constructor instead.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new \code{\link{CubicalComplex}} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CubicalComplex-betti_numbers"></a>}}
\if{latex}{\out{\hypertarget{method-CubicalComplex-betti_numbers}{}}}
\subsection{Method \code{betti_numbers()}}{
This function returns the Betti numbers of the complex.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CubicalComplex$betti_numbers()}\if{html}{\out{</div>}}
}

\subsection{Details}{
The \verb{$betti_numbers()} method always returns \verb{[1, 0, 0, ...]} as
infinity filtration cubes are not removed from the complex.
}

\subsection{Returns}{
An integer vector storing the Betti numbers.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CubicalComplex-cofaces_of_persistence_pairs"></a>}}
\if{latex}{\out{\hypertarget{method-CubicalComplex-cofaces_of_persistence_pairs}{}}}
\subsection{Method \code{cofaces_of_persistence_pairs()}}{
A persistence interval is described by a pair of cells, one
that creates the feature and one that kills it. The filtration values
of those 2 cells give coordinates for a point in a persistence diagram,
or a bar in a barcode. Structurally, in the cubical complexes provided
here, the filtration value of any cell is the minimum of the filtration
values of the maximal cells that contain it. Connecting persistence
diagram coordinates to the corresponding value in the input (i.e. the
filtration values of the top-dimensional cells) is useful for
differentiation purposes.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CubicalComplex$cofaces_of_persistence_pairs()}\if{html}{\out{</div>}}
}

\subsection{Details}{
This function returns a list of pairs of top-dimensional cells
corresponding to the persistence birth and death cells of the
filtration. The cells are represented by their indices in the input
list of top-dimensional cells (and not their indices in the internal
data structure that includes non-maximal cells). Note that when two
adjacent top-dimensional cells have the same filtration value, we
arbitrarily return one of the two when calling the function on one of
their common faces.
}

\subsection{Returns}{
The top-dimensional cells/cofaces of the positive and negative
cells, together with the corresponding homological dimension, in two
lists of integer arrays. The first list contains the regular
persistence pairs, grouped by dimension. It contains numpy arrays of
shape \verb{[number_of_persistence_points, 2]}. The indices of the arrays in
the list correspond to the homological dimensions, and the integers of
each row in each array correspond to: \verb{(index of positive top-dimensional cell, index of negative top-dimensional cell)}. The
second list contains the essential features, grouped by dimension. It
contains numpy arrays of shape \verb{[number_of_persistence_points, 1]}. The
indices of the arrays in the list correspond to the homological
dimensions, and the integers of each row in each array correspond to:
\verb{(index of positive top-dimensional cell)}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CubicalComplex-compute_persistence"></a>}}
\if{latex}{\out{\hypertarget{method-CubicalComplex-compute_persistence}{}}}
\subsection{Method \code{compute_persistence()}}{
This method computes the persistence of the complex, so it
can be accessed through \verb{$persistent_betti_numbers()},
\verb{$persistence_intervals_in_dimension()}, etc. It is equivalent to the
\verb{$persistence()} method when you do not want the list \verb{$persistence()}
returns.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CubicalComplex$compute_persistence(
  homology_coeff_field = 11,
  min_persistence = 0
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{homology_coeff_field}}{An integer value specifying the homology
coefficient field. Must be a prime number. Defaults to \code{11L}. Maximum
is \code{46337L}.}

\item{\code{min_persistence}}{A numeric value specifying the minimum persistence
value to take into account (strictly greater than \code{min_persistence}).
Defaults to \code{0.0}. Set \code{min_persistence = -1.0} to see all values.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The updated \code{\link{CubicalComplex}} class itself invisibly.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CubicalComplex-dimension"></a>}}
\if{latex}{\out{\hypertarget{method-CubicalComplex-dimension}{}}}
\subsection{Method \code{dimension()}}{
This function returns the dimension of the complex.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CubicalComplex$dimension()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
An integer value giving the complex dimension.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CubicalComplex-num_simplices"></a>}}
\if{latex}{\out{\hypertarget{method-CubicalComplex-num_simplices}{}}}
\subsection{Method \code{num_simplices()}}{
This function returns the number of all cubes in the
complex.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CubicalComplex$num_simplices()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
An integer value giving the number of all cubes in the complex.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CubicalComplex-persistence"></a>}}
\if{latex}{\out{\hypertarget{method-CubicalComplex-persistence}{}}}
\subsection{Method \code{persistence()}}{
This function computes and returns the persistence of the
complex.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CubicalComplex$persistence(homology_coeff_field = 11, min_persistence = 0)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{homology_coeff_field}}{An integer value specifying the homology
coefficient field. Must be a prime number. Defaults to \code{11L}. Maximum
is \code{46337L}.}

\item{\code{min_persistence}}{A numeric value specifying the minimum persistence
value to take into account (strictly greater than \code{min_persistence}).
Defaults to \code{0.0}. Set \code{min_persistence = -1.0} to see all values.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A \code{\link[tibble]{tibble}} listing all persistence feature
summarised by 3 variables: \code{dimension}, \code{birth} and \code{death}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CubicalComplex-persistence_intervals_in_dimension"></a>}}
\if{latex}{\out{\hypertarget{method-CubicalComplex-persistence_intervals_in_dimension}{}}}
\subsection{Method \code{persistence_intervals_in_dimension()}}{
This function returns the persistence intervals of the
complex in a specific dimension.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CubicalComplex$persistence_intervals_in_dimension(dimension)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{dimension}}{An integer value specifying the desired dimension.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A \code{\link[tibble]{tibble}} storing the persistence intervals
by row.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CubicalComplex-persistent_betti_numbers"></a>}}
\if{latex}{\out{\hypertarget{method-CubicalComplex-persistent_betti_numbers}{}}}
\subsection{Method \code{persistent_betti_numbers()}}{
This function returns the persistent Betti numbers of the
complex.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CubicalComplex$persistent_betti_numbers(from_value, to_value)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{from_value}}{A numeric value specifying the persistence birth limit
to be added in the numbers (\verb{persistent birth <= from_value}).}

\item{\code{to_value}}{A numeric value specifying the persistence death limit to
be added in the numbers (\verb{persistent death > to_value}).}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
An integer vector storing the persistent Betti numbers.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CubicalComplex-clone"></a>}}
\if{latex}{\out{\hypertarget{method-CubicalComplex-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CubicalComplex$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
