% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rhandsontable.R
\name{hot_col}
\alias{hot_col}
\title{Handsontable widget}
\usage{
hot_col(hot, col, type = NULL, format = NULL, source = NULL,
  strict = NULL, readOnly = NULL, validator = NULL, allowInvalid = NULL,
  halign = NULL, valign = NULL, renderer = NULL, copyable = NULL,
  dateFormat = NULL, default = NULL, language = NULL, ...)
}
\arguments{
\item{hot}{rhandsontable object}

\item{col}{vector of column names or indices}

\item{type}{character specify the data type. Options include:
numeric, date, checkbox, select, dropdown, autocomplete, password,
and handsontable (not implemented yet)}

\item{format}{characer specifying column format. See Cell Types at
\href{http://handsontable.com}{Handsontable.js} for the formatting
options for each data type. Numeric columns are formatted using
\href{http://numeraljs.com}{Numeral.js}.}

\item{source}{a vector of choices for select, dropdown and autocomplete
column types}

\item{strict}{logical specifying whether values not in the \code{source}
vector will be accepted}

\item{readOnly}{logical making the table read-only}

\item{validator}{character defining a Javascript function to be used
to validate user input. See \code{hot_validate_numeric} and
\code{hot_validate_character} for pre-build validators.}

\item{allowInvalid}{logical specifying whether invalid data will be
accepted. Invalid data cells will be color red.}

\item{halign}{character defining the horizontal alignment. Possible
values are htLeft, htCenter, htRight and htJustify}

\item{valign}{character defining the vertical alignment. Possible
values are htTop, htMiddle, htBottom}

\item{renderer}{character defining a Javascript function to be used
to format column cells. Can be used to implement conditional formatting.}

\item{copyable}{logical defining whether data in a cell can be copied using
Ctrl + C}

\item{dateFormat}{character defining the date format. See
{https://github.com/moment/moment}{Moment.js} for details.}

\item{default}{default column value for new rows (NA if not specified; shiny only)}

\item{language}{locale passed to \href{http://numeraljs.com}{Numeral.js};
default is 'en'.}

\item{...}{passed to handsontable}
}
\description{
Configure single column.
}
\examples{
library(rhandsontable)
DF = data.frame(val = 1:10, bool = TRUE, big = LETTERS[1:10],
                small = letters[1:10],
                dt = seq(from = Sys.Date(), by = "days", length.out = 10),
                stringsAsFactors = FALSE)

rhandsontable(DF, rowHeaders = NULL) \%>\%
  hot_col(col = "big", type = "dropdown", source = LETTERS) \%>\%
  hot_col(col = "small", type = "autocomplete", source = letters,
          strict = FALSE)
}
\seealso{
\code{\link{hot_cols}}, \code{\link{hot_rows}}, \code{\link{hot_cell}}
}

