% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/validate_hypergraph.R
\name{validate_hypergraph}
\alias{validate_hypergraph}
\title{Quickly Validate a Hypergraph}
\usage{
validate_hypergraph(hype, return = FALSE, verbose = TRUE)
}
\arguments{
\item{hype}{A hypergraph object}

\item{return}{A logical variable stating whether any output should be
returned from the function}

\item{verbose}{A logical variable indicating whether the function should
output text to the screen}
}
\value{
Outputs text to screen of any problems found within the hypergraph
object. If \code{return} is set to \code{TRUE} then a logical output will be
returned. This logical output will be \code{TRUE} if it passed all of the
tests, \code{FALSE} if it failed any test that proves the structure of the
hypergraph is broken or \code{NULL} if it failed a test that most hypergraphs
used practically should pass, but doesn't necessarily mean the
hypergraph is broken, see text output for more details.
}
\description{
When using the rhype functions, the integrity of a hypergraph object should
remain intact. However, as the properties of a hypergraph object are
dependent on one another, it is possible in the case of an error or direct
object manipulation by the user that a hypergraph object's integrity is
corrupted. This will cause other rhype functions to either throw errors or to
calculate incorrect answers. This function is not exhaustive but will perform
multiple sanity checks on hypergraph objects and is a good place to start
when debugging.
}
\examples{
h <- example_hype()
validate_hypergraph(h)
}
