% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/condensedIdentity.R
\name{condensedIdentityX}
\alias{condensedIdentityX}
\title{Identity coefficients on X}
\usage{
condensedIdentityX(x, ids, sparse = NA, simplify = TRUE, verbose = FALSE)
}
\arguments{
\item{x}{A pedigree in the form of a \code{\link[pedtools:ped]{pedtools::ped}} object}

\item{ids}{A character (or coercible to character) containing ID labels of
two or more pedigree members.}

\item{sparse}{A positive integer, indicating the pedigree size limit for
using sparse arrays (as implemented by the
\href{https://CRAN.R-project.org/package=slam}{slam} package) instead of
ordinary arrays.}

\item{simplify}{Simplify the output (to a numeric of length 9) if \code{ids} has
length 2. Default: TRUE.}

\item{verbose}{A logical}
}
\value{
If \code{ids} has length 2 and \code{simplify = TRUE}: A vector of length 9,
containing the condensed identity coefficients. If any of the individuals
are male, certain states are undefined, and the corresponding coefficients
are NA. (See Details.)

Otherwise, a data frame with 11 columns and one row for each pair of
individuals. The first two columns contain the ID labels, and columns 3-11
contain the condensed identity coefficients.
}
\description{
Computes the X chromosomal condensed identity coefficients of a pairwise
relationship.
}
\details{
The implementation is inspired by Karigl's recursive algorithm (1981) for the
autosomal case, modified to account for X-linked inheritance.

The X chromosomal pairwise identity states depend on the sexes of the two
individuals. If both are female, the states are the same as in the autosomal
case. When males are involved, the two individuals have less than 4 alleles,
hence the states differ from the autosomal ones. However, to avoid drawing
(and learning) new pictures we re-use the autosomal states by using the
following simple rule: \strong{Replace any hemizygous male allele with a pair of
autozygous alleles}. In this way each X state corresponds to a unique
autosomal state.

For simplicity the output always contains 9 coefficients, but with NA's in
the positions of undefined states (depending on the sex combination). The
README file on the GitHub home page of ribd has a table illustrating this.
}
\examples{

x = fullSibMating(1)
x_sisters = swapSex(x, 5)
x_brothers = swapSex(x, 6)

condensedIdentityX(x, ids = 5:6)
condensedIdentityX(x_sisters, ids = 5:6)
condensedIdentityX(x_brothers, ids = 5:6)

}
\seealso{
\code{\link[=kinship]{kinship()}}, \code{\link[=identityCoefs]{identityCoefs()}}, \code{\link[pedtools:founderInbreeding]{pedtools::founderInbreeding()}}
}
