% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tbl-utils.R
\name{rename_cols}
\alias{rename_cols}
\alias{rm_cols}
\alias{change_interval}
\alias{change_dur_unit}
\alias{rm_na}
\alias{sort.id_tbl}
\alias{is_sorted}
\alias{duplicated.id_tbl}
\alias{anyDuplicated.id_tbl}
\alias{unique.id_tbl}
\alias{is_unique}
\alias{aggregate.id_tbl}
\alias{dt_gforce}
\alias{replace_na}
\title{ICU class data utilities}
\usage{
rename_cols(
  x,
  new,
  old = colnames(x),
  skip_absent = FALSE,
  by_ref = FALSE,
  ...
)

rm_cols(x, cols, skip_absent = FALSE, by_ref = FALSE)

change_interval(x, new_interval, cols = time_vars(x), by_ref = FALSE)

change_dur_unit(x, new_unit, by_ref = FALSE)

rm_na(x, cols = data_vars(x), mode = c("all", "any"))

\method{sort}{id_tbl}(
  x,
  decreasing = FALSE,
  by = meta_vars(x),
  reorder_cols = TRUE,
  by_ref = FALSE,
  ...
)

is_sorted(x)

\method{duplicated}{id_tbl}(x, incomparables = FALSE, by = meta_vars(x), ...)

\method{anyDuplicated}{id_tbl}(x, incomparables = FALSE, by = meta_vars(x), ...)

\method{unique}{id_tbl}(x, incomparables = FALSE, by = meta_vars(x), ...)

is_unique(x, ...)

\method{aggregate}{id_tbl}(
  x,
  expr = NULL,
  by = meta_vars(x),
  vars = data_vars(x),
  env = NULL,
  ...
)

dt_gforce(
  x,
  fun = c("mean", "median", "min", "max", "sum", "prod", "var", "sd", "first", "last",
    "any", "all"),
  by = meta_vars(x),
  vars = data_vars(x),
  na_rm = !fun \%in\% c("first", "last")
)

replace_na(x, val, type = "const", ...)
}
\arguments{
\item{x}{Object to query}

\item{new, old}{Replacement names and existing column names for renaming
columns}

\item{skip_absent}{Logical flag for ignoring non-existent column names}

\item{by_ref}{Logical flag indicating whether to perform the operation by
reference}

\item{...}{Ignored}

\item{cols}{Column names of columns to consider}

\item{new_interval}{Replacement interval length specified as scalar-valued
\code{difftime} object}

\item{new_unit}{New \code{difftime} unit for the \code{dur_var} column}

\item{mode}{Switch between \code{all} where all entries of a row have to be
missing (for the selected columns) or \code{any}, where a single missing entry
suffices}

\item{decreasing}{Logical flag indicating the sort order}

\item{by}{Character vector indicating which combinations of columns from
\code{x} to use for uniqueness checks}

\item{reorder_cols}{Logical flag indicating whether to move the \code{by}
columns to the front.}

\item{incomparables}{Not used. Here for S3 method consistency}

\item{expr}{Expression to apply over groups}

\item{vars}{Column names to apply the function to}

\item{env}{Environment to look up names in \code{expr}}

\item{fun}{Function name (as string) to apply over groups}

\item{na_rm}{Logical flag indicating how to treat \code{NA} values}

\item{val}{Replacement value (if \code{type} is \code{"const"})}

\item{type}{ character, one of \emph{"const"}, \emph{"locf"} or \emph{"nocb"}. Defaults to \code{"const"}. }
}
\value{
Most of the utility functions return an object inheriting from
\code{id_tbl}, potentially modified by reference, depending on the type of the
object passed as \code{x}. The functions \code{is_sorted()}, \code{anyDuplicated()} and
\code{is_unique()} return logical flags, while \code{duplicated()} returns a logical
vector of the length \code{nrow(x)}.
}
\description{
Several utility functions for working with \code{id_tbl} and \code{ts_tbl} objects
are available, including functions for changing column names, removing
columns, as well as aggregating or removing rows. An important thing to
note is that as \code{id_tbl} (and consequently \code{ts_tbl}) inherits from
\code{data.table}, there are several functions provided by the \code{data.table}
package that are capable of modifying \code{id_tbl} in a way that results in an
object with inconsistent state. An example for this is
\code{\link[data.table:setattr]{data.table::setnames()}}: if an ID column or the index column name is
modified without updating the attribute marking the column as such, this
leads to an invalid object. As \code{\link[data.table:setattr]{data.table::setnames()}} is not an S3
generic function, the only way to control its behavior with respect to
\code{id_tbl} objects is masking the function. As such an approach has its own
down-sides, a separate function, \code{rename_cols()} is provided, which is able
to handle column renaming correctly.
}
\details{
Apart from a function for renaming columns while respecting attributes
marking columns a index or ID columns, several other utility functions are
provided to make handling of \code{id_tbl} and \code{ts_tbl} objects more convenient.
\subsection{Sorting}{

An \code{id_tbl} or \code{ts_tbl} object is considered sorted when rows are in
ascending order according to columns as specified by \code{\link[=meta_vars]{meta_vars()}}. This
means that for an \code{id_tbl} object rows have to be ordered by \code{\link[=id_vars]{id_vars()}}
and for a \code{ts_tbl} object rows have to be ordered first by \code{\link[=id_vars]{id_vars()}},
followed by the \code{\link[=index_var]{index_var()}}. Calling the S3 generic function
\code{\link[base:sort]{base::sort()}} on an object that inherits form \code{id_tbl} using default
arguments yields an object that is considered sorted. For convenience
(mostly in printing), the column by which the table was sorted are moved to
the front (this can be disabled by passing \code{FALSE} as \code{reorder_cols}
argument). Internally, sorting is handled by either setting a
\code{\link[data.table:setkey]{data.table::key()}} in case \code{decreasing = FALSE} or be calling
\code{\link[data.table:setorder]{data.table::setorder()}} in case \code{decreasing = TRUE}.
}

\subsection{Uniqueness}{

On object inheriting form \code{id_tbl} is considered unique if it is unique in
terms of the columns as specified by \code{\link[=meta_vars]{meta_vars()}}. This means that for an
\code{id_tbl} object, either zero or a single row is allowed per combination of
values in columns \code{\link[=id_vars]{id_vars()}} and consequently for \code{ts_tbl} objects a
maximum of one row is allowed per combination of time step and ID. In order
to create a unique \code{id_tbl} object from a non-unique \code{id_tbl} object,
\code{aggregate()} will combine observations that represent repeated
measurements within a group.
}

\subsection{Aggregating}{

In order to turn a non-unique \code{id_tbl} or \code{ts_tbl} object into an object
considered unique, the S3 generic function \code{\link[stats:aggregate]{stats::aggregate()}} is
available. This applied the expression (or function specification) passed
as \code{expr} to each combination of grouping variables. The columns to be
aggregated can be controlled using the \code{vars} argument and the grouping
variables can be changed using the \code{by} argument. The argument \code{expr} is
fairly flexible: it can take an expression that will be evaluated in the
context of the \code{data.table} in a clean environment inheriting from \code{env},
it can be a function, or it can be a string in which case \code{dt_gforce()} is
called. The default value \code{NULL} chooses a string dependent on data types,
where \code{numeric} resolves to \code{median}, \code{logical} to \code{sum} and \code{character} to
\code{first}.

As aggregation is used in concept loading (see \code{\link[=load_concepts]{load_concepts()}}),
performance is important. For this reason, \code{dt_gforce()} allows for any of
the available functions to be applied using the \code{GForce} optimization of
\code{data.table} (see \link[data.table:datatable-optimize]{data.table::datatable.optimize}).
}
}
\examples{
tbl <- id_tbl(a = rep(1:5, 4), b = rep(1:2, each = 10), c = rnorm(20),
              id_vars = c("a", "b"))
is_unique(tbl)
is_sorted(tbl)

is_sorted(tbl[order(c)])

identical(aggregate(tbl, list(c = sum(c))), aggregate(tbl, "sum"))

tbl <- aggregate(tbl, "sum")
is_unique(tbl)
is_sorted(tbl)

}
