% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/callback-cncpt.R
\encoding{UTF-8}
\name{pafi}
\alias{pafi}
\alias{safi}
\alias{vent_ind}
\alias{gcs}
\alias{urine24}
\alias{vaso60}
\alias{vaso_ind}
\alias{supp_o2}
\alias{avpu}
\alias{bmi}
\alias{norepi_equiv}
\title{Concept callback functions}
\usage{
pafi(
  ...,
  match_win = hours(2L),
  mode = c("match_vals", "extreme_vals", "fill_gaps"),
  fix_na_fio2 = TRUE,
  interval = NULL
)

safi(
  ...,
  match_win = hours(2L),
  mode = c("match_vals", "extreme_vals", "fill_gaps"),
  fix_na_fio2 = TRUE,
  interval = NULL
)

vent_ind(..., match_win = hours(6L), min_length = mins(30L), interval = NULL)

gcs(
  ...,
  valid_win = hours(6L),
  sed_impute = c("max", "prev", "none", "verb"),
  set_na_max = TRUE,
  interval = NULL
)

urine24(
  ...,
  min_win = hours(12L),
  limits = NULL,
  start_var = "start",
  end_var = "end",
  interval = NULL
)

vaso60(..., max_gap = mins(5L), interval = NULL)

vaso_ind(..., interval = NULL)

supp_o2(..., interval = NULL)

avpu(..., interval = NULL)

bmi(..., interval = NULL)

norepi_equiv(..., interval = NULL)
}
\arguments{
\item{...}{Data input used for concept calculation}

\item{match_win}{Time-span during which matching of values is allowed}

\item{mode}{Method for matching PaO\ifelse{latex
}{\out{\textsubscript{2}}}{\ifelse{html}{\out{<sub>2</sub>}}{2}} and
FiO\ifelse{latex}{\out{\textsubscript{2}}}{\ifelse{html
}{\out{<sub>2</sub>}}{2}} values}

\item{fix_na_fio2}{Logical flag indicating whether to impute missing
FiO\ifelse{latex}{\out{\textsubscript{2}}}{\ifelse{html
}{\out{<sub>2</sub>}}{2}} values with 21}

\item{interval}{Expected time series step size (determined from data if
\code{NULL})}

\item{min_length}{Minimal time span between a ventilation start and end
time}

\item{valid_win}{Maximal time window for which a GCS value is valid
if no newer measurement is available}

\item{sed_impute}{Imputation scheme for values taken when patient was
sedated (i.e. unconscious).}

\item{set_na_max}{Logical flag controlling imputation of missing GCS values
with the respective maximum values}

\item{min_win}{Minimal time span required for calculation of urine/24h}

\item{limits}{Passed to \code{\link[=fill_gaps]{fill_gaps()}} in order to expand the time series
beyond first and last measurements}

\item{start_var, end_var}{Passed to \code{\link[=fill_gaps]{fill_gaps()}}}

\item{max_gap}{Maximum time gap between administration windows that are
merged (can be negative).}
}
\value{
Either an \code{id_tbl} or \code{ts_tbl} depending on the type of concept.
}
\description{
Owing to increased complexity and more diverse applications, recursive
concepts (class \code{\link[=new_cncpt]{rec_cncpt}}) may specify callback functions
to be called on corresponding data objects and perform post-processing
steps.
}
\details{
Several concept callback functions are exported, mainly for documenting
their arguments, as default values oftentimes represent somewhat arbitrary
choices and passing non-default values might be of interest for
investigating stability with respect to such choices. Furthermore, default
values might not be ideal for some datasets and/or analysis tasks.
\subsection{\code{pafi}}{

In order to calculate the PaO\ifelse{latex
}{\out{\textsubscript{2}}}{\ifelse{html}{\out{<sub>2</sub>}}{2}}/FiO\ifelse{
latex}{\out{\textsubscript{2}}}{\ifelse{html}{\out{<sub>2</sub>}}{2}} (or
Horowitz index), for a given time point, both a PaO\ifelse{
latex}{\out{\textsubscript{2}}}{\ifelse{html}{\out{<sub>2</sub>}}{2}} and a
FiO\ifelse{latex}{\out{\textsubscript{2}}}{\ifelse{html
}{\out{<sub>2</sub>}}{2}} measurement is required. As the two are often
not measured at the same time, some form of imputation or matching
procedure is required. Several options are available:
\itemize{
\item \code{match_vals} allows for a time difference of maximally \code{match_win}
between two measurements for calculating their ratio
\item \code{extreme_vals} uses the worst PaO\ifelse{latex
  }{\out{\textsubscript{2}}}{\ifelse{html}{\out{<sub>2</sub>}}{2}} and a
FiO\ifelse{latex}{\out{\textsubscript{2}}}{\ifelse{html
  }{\out{<sub>2</sub>}}{2}} values within the time window spanned by
\code{match_win}
\item \code{fill_gaps} represents a variation of \code{extreme_vals}, where ratios are
evaluated at every time-point as specified by \code{interval}as opposed to
only the time points where either a PaO\ifelse{latex
  }{\out{\textsubscript{2}}}{\ifelse{html}{\out{<sub>2</sub>}}{2}} or a
FiO\ifelse{latex}{\out{\textsubscript{2}}}{\ifelse{html
  }{\out{<sub>2</sub>}}{2}} measurement is available
}

Finally, \code{fix_na_fio2} imputes all remaining missing FiO\ifelse{latex
}{\out{\textsubscript{2}}}{\ifelse{html}{\out{<sub>2</sub>}}{2}} with 21,
the percentage (by volume) of oxygen in (tropospheric) air.
}

\subsection{\code{vent_ind}}{

Building on the atomic concepts \code{vent_start} and \code{vent_end}, \code{vent_ind}
determines time windows during which patients are mechanically ventilated
by combining start and end events that are separated by at most \code{match_win}
and at least \code{min_length}. Durations are represented by the \code{dur_var} column
in the returned \code{win_tbl} and the \code{data_var} column simply indicates the
ventilation status with \code{TRUE} values. Currently, no clear distinction
between invasive an non-invasive ventilation is made.
}

\subsection{\code{sed_gcs}}{

In order to construct an indicator for patient sedation (used within the
context of \code{gcs}), information from the two concepts \code{ett_gcs} and \code{rass} is
pooled: A patient is considered sedated if intubated or has less or equal to
-2 on the Richmond Agitation-Sedation Scale.
}

\subsection{\code{gcs}}{

Aggregating components of the Glasgow Coma Scale into a total score
(whenever the total score \code{tgcs} is not already available) requires
coinciding availability of an eye (\code{egcs}), verbal (\code{vgcs}) and motor
(\code{mgcs}) score. In order to match values, a last observation carry forward
imputation scheme over the time span specified by \code{valid_win} is performed.
Furthermore passing \code{"max"} as \code{sed_impute} will assume maximal points for
time steps where the patient is sedated (as indicated by \code{sed_gcs}), while
passing \code{"prev"}, will assign the last observed value previous to the
current sedation window and finally passing \code{FALSE} will in turn use raw
values. Finally, passing \code{TRUE} as \code{set_na_max} will assume maximal points
for missing values (after matching and potentially applying \code{sed_impute}).
}

\subsection{\code{urine24}}{

Single urine output events are aggregated into a 24 hour moving window sum.
At default value of \code{limits = NULL}, moving window evaluation begins with
the first and ends with the last available measurement. This can however be
extended by passing an \code{id_tbl} object, such as for example returned by
\code{\link[=stay_windows]{stay_windows()}} to full stay windows. In order to provide data earlier
than 24 hours before the evaluation start point, \code{min_win} specifies the
minimally required data window and the evaluation scheme is adjusted for
shorter than 24 hour windows.
}

\subsection{\code{vaso60}}{

Building on concepts for drug administration rate and drug administration
durations, administration events are filtered if they do not fall into
administrations windows of at least 1h. The \code{max_gap} argument can be used
to control how far apart windows can be in order to be merged (negative
times are possible as well, meaning that even overlapping windows can be
considered as individual windows).
}
}
