% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/regress.R
\name{regress}
\alias{regress}
\alias{fitted.uRegress}
\alias{print.augCoefficients}
\alias{print.uRegress}
\alias{uLRtest}
\alias{uWaldtest}
\title{General Regression for an Arbitrary Functional}
\usage{
regress(
  fnctl,
  formula,
  data,
  intercept = TRUE,
  weights = rep(1, nrow(data)),
  subset = rep(TRUE, nrow(data)),
  robustSE = TRUE,
  conf.level = 0.95,
  exponentiate = fnctl != "mean",
  replaceZeroes,
  useFdstn = TRUE,
  suppress = FALSE,
  na.action,
  method = "qr",
  qr = TRUE,
  singular.ok = TRUE,
  contrasts = NULL,
  offset,
  control = list(...),
  ...
)
}
\arguments{
\item{fnctl}{a character string indicating
the functional (summary measure of the distribution) for which inference is
desired. Choices include \code{"mean"}, \code{"geometric mean"},
\code{"odds"}, \code{"rate"}.}

\item{formula}{an object of class \code{formula} as might be passed to 
\code{lm} or \code{glm}. Functions of variables, specified using \code{\link[rigr]{dummy}}
or \code{\link[rigr]{polynomial}} may also be included in \code{formula}.}

\item{data}{a data frame, matrix, or other data structure with matching
names to those entered in \code{formula}.}

\item{intercept}{a logical value
indicating whether a intercept exists or not. Default value is \code{TRUE} for all 
functionals. Intercept may also be removed if a "-1" is present in \code{formula}. If "-1"
is present in \code{formula} but \code{intercept = TRUE} is specified, the model will fit
without an intercept.}

\item{weights}{vector indicating
optional weights for weighted regression.}

\item{subset}{vector indicating a subset
to be used for all inference.}

\item{robustSE}{a logical indicator
that standard errors are to be computed using the Huber-White sandwich
estimator.}

\item{conf.level}{a numeric scalar
indicating the level of confidence to be used in computing confidence
intervals. The default is 0.95.}

\item{exponentiate}{a logical
indicator that the regression parameters should be exponentiated. This is by
default true for all functionals except the mean.}

\item{replaceZeroes}{if not
\code{FALSE}, this indicates a value to be used in place of zeroes when
computing a geometric mean. If \code{TRUE}, a value equal to one-half the
lowest nonzero value is used. If a numeric value is supplied, that value is
used. Defaults to \code{TRUE} when \code{fnctl = "geometric mean"}. This parameter
is always \code{FALSE} for all other values of \code{fnctl}.}

\item{useFdstn}{a logical indicator
that the F distribution should be used for test statistics instead of the
chi squared distribution even in logistic regression
models. When using the F distribution, the degrees of freedom are taken to
be the sample size minus the number of parameters, as it would be in a
linear regression model.}

\item{suppress}{if \code{TRUE}, and a model which requires exponentiation
(for instance, regression on the geometric mean) is computed, then a table
with only the exponentiated coefficients and confidence interval is
returned. Otherwise, two tables are returned - one with the original
unexponentiated coefficients, and one with the exponentiated coefficients.}

\item{na.action, qr, singular.ok, offset, contrasts, control}{optional arguments that are passed to the functionality of \code{lm} or
\code{glm}.}

\item{method}{the method to be used in fitting the model. The default value for
\code{fnctl = "mean"} and \code{fnctl = "geometric mean"} is \code{"qr"}, and the default value for
\code{fnctl = "odds"} and \code{fnctl = "rate"} is \code{"glm.fit"}. This argument is passed into the
lm() or glm() function, respectively. You may optionally specify \code{method = "model.frame"}, which
returns the model frame and does no fitting.}

\item{...}{additional arguments to be passed to the \code{lm} function call}
}
\value{
An object of class uRegress is
returned. Parameter estimates, confidence intervals, and p values are
contained in a matrix $augCoefficients.
}
\description{
Produces point estimates, interval estimates, and p values for an arbitrary
functional (mean, geometric mean, proportion, odds) of a
variable of class \code{integer}, or \code{numeric} when
regressed on an arbitrary number of covariates. Multiple Partial F-tests can
be specified using the \code{\link[rigr]{U}} function.
}
\details{
Regression models include linear regression (for the ``mean'' functional), logistic
regression with logit link (for the ``odds'' functional), Poisson regression with log link (for the
``rate'' functional), and a linear regression of a log-transformed outcome 
(for the ``geometric mean'' functional). Proportional hazards regression is currently not
supported in the \code{regress} function. 

Note that the only possible link function in `regress` with `fnctl = odds"` is the logit link. 
Similarly, the only possible link function in `regress` with `fnctl = "rate"` is the log link.

Objects created using the
\code{\link[rigr]{U}} function can also be passed in. If the
\code{\link[rigr]{U}} call involves a partial formula of the form
\code{~ var1 + var2}, then \code{regress} will return a multiple-partial
F-test involving \code{var1} and \code{var2}. If an F-statistic will already be 
calculated regardless of the \code{\link[rigr]{U}} specification,
then any naming convention specified via \code{name ~ var1} will be ignored.
The multiple partial tests must be the last terms specified in the model (i.e. no other predictors can
follow them).
}
\examples{
# Loading dataset
data(mri)

# Linear regression of atrophy on age
regress("mean", atrophy ~ age, data = mri)

# Linear regression of atrophy on sex and height and their interaction, 
# with a multiple-partial F-test on the height-sex interaction
regress("mean", atrophy ~ height + sex + U(hs=~height:sex), data = mri)

# Logistic regression of sex on atrophy
mri$sex_bin <- ifelse(mri$sex == "Female", 1, 0)
regress("odds", sex_bin ~ atrophy, data = mri)


}
\seealso{
Functions for fitting linear models (\code{\link[stats]{lm}}), and
generalized linear models (\code{\link[stats]{glm}}). Also see the function to specify
multiple-partial F-tests, \code{\link[rigr]{U}}.
}
