% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summarize_scores.R
\name{summarize_scores}
\alias{summarize_scores}
\title{Summarize a default set of assessments into a single risk score}
\usage{
summarize_scores(data, weights = NULL)
}
\arguments{
\item{data}{a \code{\link[tibble]{tibble}} of scored assessments whose column
names match those provided by riskmetric's \code{\link{pkg_assess}} function.}

\item{weights}{an optional vector of non-negative weights to be assigned to
each assessment.}
}
\value{
a numeric vector of risk scores
}
\description{
This function serves as an example for how a risk score might be derived.
Assuming all assessments provided by \code{riskmetric} are available in a
dataset, this function can be used to calculate a vector of risks.
}
\examples{
\dontrun{
library(dplyr)
summarize_scores(pkg_score(pkg_assess(as_tibble(pkg_ref("riskmetric")))))
}

# or, using the cleaner dplyr syntax
\dontrun{
library(dplyr)
pkg_ref("riskmetric") \%>\%
  pkg_assess() \%>\%
  pkg_score() \%>\%
  summarize_scores()
}

}
