% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assess_downloads.R
\name{metric_score.pkg_metric_downloads_1yr}
\alias{metric_score.pkg_metric_downloads_1yr}
\title{Defining an Assessment Scoring Function}
\usage{
\method{metric_score}{pkg_metric_downloads_1yr}(x, ...)
}
\arguments{
\item{x}{a \code{pkg_metric_downloads_1yr} packge metric object}

\item{...}{additional arguments unused}
}
\value{
numeric value between \code{0} (low) and \code{1} (high download
  volume) converting the number of downloads.
}
\description{
Score a package for the number of downloads in the past year regularized
Convert the number of downloads \code{x} in the past year into a validation
score [0,1] \deqn{ 1 - 150,000 / (x + 150,000) }
}
\details{
The scoring function is a simplification of the classic logistic curve \deqn{
1 / (1 + exp(-k(x-x[0])) } with a log scale for the number of downloads
\eqn{x = log(x)}, sigmoid midpoint is 1000 downloads, ie. \eqn{x[0] =
log(1,000)}, and logistic growth rate of \eqn{k = 0.5}.

\deqn{ 1 - 1 / (1 + exp(log(x)-log(1.5e5))) = 1 - 150,000 / (x + 150,000) }
}
\examples{
\dontrun{metric_score(assess_downloads_1yr(pkg_ref("riskmetric")))
}
}
