% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_plane.R
\name{plot_plane}
\alias{plot_plane}
\title{Plot a plane of selected values (e.g., PPV or NPV)
as a function of sensitivity and specificity.}
\usage{
plot_plane(prev = num$prev, sens = num$sens, mirt = NA, spec = num$spec,
  fart = NA, what = "PPV", what.col = pal, show.point = TRUE,
  step.size = 0.05, theta = -45, phi = 0, title.lbl = txt$scen.lbl,
  cex.lbl = 0.85)
}
\arguments{
\item{prev}{The condition's prevalence \code{\link{prev}}
(i.e., the probability of condition being \code{TRUE}).}

\item{sens}{The decision's sensitivity \code{\link{sens}}
(i.e., the conditional probability of a positive decision
provided that the condition is \code{TRUE}).
\code{sens} is optional when its complement \code{mirt} is provided.}

\item{mirt}{The decision's miss rate \code{\link{mirt}}
(i.e., the conditional probability of a negative decision
provided that the condition is \code{TRUE}).
\code{mirt} is optional when its complement \code{sens} is provided.}

\item{spec}{The decision's specificity value \code{\link{spec}}
(i.e., the conditional probability
of a negative decision provided that the condition is \code{FALSE}).
\code{spec} is optional when its complement \code{fart} is provided.}

\item{fart}{The decision's false alarm rate \code{\link{fart}}
(i.e., the conditional probability
of a positive decision provided that the condition is \code{FALSE}).
\code{fart} is optional when its complement \code{spec} is provided.}

\item{what}{A character code that specifies one metric
to be plotted as a plane. Currently available
options are \code{c("PPV", "NPV", "ppod", "acc")}.
Default: \code{what = "PPV"}.}

\item{what.col}{A color corresponding to the metric
specified in \code{what}.
Default: \code{what.col = pal}.}

\item{show.point}{Boolean option for showing the current value
of the selected metric for the current conditions
(\code{\link{prev}}, \code{\link{sens}}, \code{\link{spec}})
as a point on the plane.
Default: \code{show.point = TRUE}.}

\item{step.size}{Sets the granularity of the
\code{\link{sens}}-by-\code{\link{spec}} grid.
Default: \code{step.size = .05}.}

\item{theta}{Horizontal rotation angle (used by \code{\link{persp}}).
Default: \code{theta = -45}.}

\item{phi}{Vertical rotation angle (used by \code{\link{persp}}).
Default: \code{phi = 0}.}

\item{title.lbl}{The title of the current plot.
Default: \code{title.lbl = txt$scen.lbl}.}

\item{cex.lbl}{Scaling factor for the size of text labels
(e.g., on axes, legend, margin text).
Default: \code{cex.lbl = .85}.}
}
\description{
\code{plot_plane} draws a 3D-plane of selected values
(e.g., predictive values \code{\link{PPV}}
or \code{\link{NPV}}) as a function of
a decision's sensitivity \code{\link{sens}} and
specificity value \code{\link{spec}}
for a given prevalence (\code{\link{prev}}).
}
\details{
\code{plot_plane} is a generalization of
\code{plot_PV3d} (see legacy code)
that allows for additional dependent values.
}
\examples{
# Basics:
plot_plane()  # => current defaults (what = "PPV")
plot_plane(what = "PPV")  # => plane of PPV
plot_plane(what = "NPV")  # => plane of NPV
plot_plane(what = "ppod") # => plane of ppod
plot_plane(what = "acc")  # => plane of acc

# Options:
plot_plane(title.lbl = "Testing smaller text labels", cex.lbl = .60)
plot_plane(show.point = FALSE)  # => no point shown on plane
plot_plane(step.size = .333, what.col = "firebrick")  # => coarser granularity + color
plot_plane(step.size = .025, what.col = "chartreuse4")  # => finer granularity + color
plot_plane(what.col = "steelblue4", theta = -90, phi = 45)  # => rotated, from above


}
\seealso{
\code{\link{comp_popu}} computes the current population;
\code{\link{popu}} contains the current population;
\code{\link{comp_freq}} computes current frequency information;
\code{\link{freq}} contains current frequency information;
\code{\link{num}} for basic numeric parameters;
\code{\link{txt}} for current text settings;
\code{\link{pal}} for current color settings

Other visualization functions: \code{\link{plot.riskyr}},
  \code{\link{plot_curve}}, \code{\link{plot_fnet}},
  \code{\link{plot_icons}}, \code{\link{plot_mosaic}},
  \code{\link{plot_tree}}
}
