% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/comp_prob_prob.R
\name{comp_complete_prob_set}
\alias{comp_complete_prob_set}
\title{Compute a complete set of probabilities from valid probability inputs.}
\usage{
comp_complete_prob_set(prev, sens = NA, mirt = NA, spec = NA,
  fart = NA)
}
\arguments{
\item{prev}{The condition's prevalence \code{\link{prev}}
(i.e., the probability of condition being \code{TRUE}).}

\item{sens}{The decision's sensitivity \code{\link{sens}}
(i.e., the conditional probability of a positive decision
provided that the condition is \code{TRUE}).
\code{sens} is optional when its complement \code{mirt} is provided.}

\item{mirt}{The decision's miss rate \code{\link{mirt}}
(i.e., the conditional probability of a negative decision
provided that the condition is \code{TRUE}).
\code{mirt} is optional when its complement \code{sens} is provided.}

\item{spec}{The decision's specificity value \code{\link{spec}}
(i.e., the conditional probability
of a negative decision provided that the condition is \code{FALSE}).
\code{spec} is optional when its complement \code{fart} is provided.}

\item{fart}{The decision's false alarm rate \code{\link{fart}}
(i.e., the conditional probability
of a positive decision provided that the condition is \code{FALSE}).
\code{fart} is optional when its complement \code{spec} is provided.}
}
\value{
A vector of 5 probabilities:
\code{c(\link{prev}, \link{sens}, \link{mirt}, \link{spec}, \link{fart})}.
}
\description{
\code{comp_complete_prob_set} is a function takes a
valid set of (3 to 5) probabilities as inputs (as a vector)
and returns the complete set of
(3 essential and 2 optional) probabilities.
}
\details{
Assuming that \code{\link{is_valid_prob_set} = TRUE}
this function uses \code{\link{comp_comp_pair}} on the
two optional pairs (i.e.,
\code{\link{sens}} and \code{\link{mirt}}, and
\code{\link{spec}} and \code{\link{fart}}) and
returns the complete set of 5 probabilities.
}
\examples{
# ways to work:
comp_complete_prob_set(1, .8, NA, .7, NA) # => 1.0 0.8 0.2 0.7 0.3
comp_complete_prob_set(1, NA, .8, NA, .4) # => 1.0 0.2 0.8 0.6 0.4

# watch out for:
comp_complete_prob_set(8)                  # => 8 NA NA NA NA + warnings
comp_complete_prob_set(8, 7, 6, 5, 4)      # => 8 7 6 5 4 + no warning (valid set assumed)
comp_complete_prob_set(8, .8, NA, .7, NA)  # => 8.0 0.8 0.2 0.7 0.3 + no warning (sic)
comp_complete_prob_set(8, 2, NA, 3, NA)    # => 8 2 NA 3 NA + no warning (sic)

}
\seealso{
\code{\link{is_valid_prob_set}} verifies a set of probability inputs;
\code{\link{is_extreme_prob_set}} verifies extreme cases;
\code{\link{comp_comp_pair}} computes pairs of complements;
\code{\link{is_complement}} verifies numeric complements;
\code{\link{is_prob}} verifies probabilities;
\code{\link{comp_prob}} computes current probability information;
\code{\link{prob}} contains current probability information;
\code{\link{init_num}} initializes basic numeric variables;
\code{\link{num}} contains basic numeric variables.

Other functions computing probabilities: \code{\link{comp_FDR}},
  \code{\link{comp_FOR}}, \code{\link{comp_NPV}},
  \code{\link{comp_PPV}}, \code{\link{comp_accu_freq}},
  \code{\link{comp_accu_prob}}, \code{\link{comp_acc}},
  \code{\link{comp_comp_pair}},
  \code{\link{comp_complement}}, \code{\link{comp_err}},
  \code{\link{comp_fart}}, \code{\link{comp_mirt}},
  \code{\link{comp_ppod}}, \code{\link{comp_prob_freq}},
  \code{\link{comp_prob}}, \code{\link{comp_sens}},
  \code{\link{comp_spec}}
}
\concept{functions computing probabilities}
