% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/init_num.R
\name{init_num}
\alias{init_num}
\title{Initialize basic numeric variables.}
\usage{
init_num(prev = num.def$prev, sens = num.def$sens,
  spec = num.def$spec, fart = num.def$fart, N = num.def$N)
}
\arguments{
\item{prev}{The condition's prevalence value \code{\link{prev}}
(i.e., the probability of condition being \code{TRUE}).}

\item{sens}{The decision's sensitivity value \code{\link{sens}}
(i.e., the conditional probability of a positive decision
provided that the condition is \code{TRUE}).}

\item{spec}{The decision's specificity value \code{\link{spec}}
(i.e., the conditional probability
of a negative decision provided that the condition is \code{FALSE}).
\code{spec} is optional when is complement \code{\link{fart}} is provided.}

\item{fart}{The decision's false alarm rate \code{\link{fart}}
(i.e., the conditional probability
of a positive decision provided that the condition is \code{FALSE}).
\code{fart} is optional when its complement \code{\link{spec}} is provided.}

\item{N}{The population size \code{\link{N}}.}
}
\value{
A list containing a valid quadruple of probabilities
(\code{\link{prev}}, \code{\link{sens}},
\code{\link{spec}}, and \code{\link{fart}})
and one frequency (population size \code{\link{N}}).
}
\description{
\code{init_num} initializes basic numeric variables to define \code{\link{num}}
as a list of named elements containing four basic probabilities
(\code{\link{prev}}, \code{\link{sens}}, \code{\link{spec}}, and \code{\link{fart}})
and one frequency parameter (the population size \code{\link{N}}).
}
\details{
If \code{\link{spec}} is provided, its complement \code{\link{fart}} is optional.
If \code{\link{fart}} is provided, its complement \code{\link{spec}} is optional.
If no \code{\link{N}} is provided, a suitable minimum value is
computed by \code{\link{comp_min_N}}.
}
\examples{
# ways to succeed:
init_num(1, 1, 1, 0, 100)  # => succeeds
init_num(1, 1, 0, 1, 100)  # => succeeds

# watch out for:
init_num(1, 1, 0, 1)           # => succeeds (with N computed)
init_num(1, 1, NA, 1, 100)     # => succeeds (with spec computed)
init_num(1, 1, 0, NA, 100)     # => succeeds (with fart computed)
init_num(1, 1, NA, 1)          # => succeeds (with spec and N computed)
init_num(1, 1, 0, NA)          # => succeeds (with fart and N computed)
init_num(1, 1, .51, .50, 100)  # => succeeds (as spec and fart are within tolarated range)

# ways to fail:
init_num(prev = NA)                                  # => NAs + warning (NA)
init_num(prev = 88)                                  # => NAs + warning (beyond range)
init_num(prev =  1, sens = NA)                       # => NAs + warning (NA)
init_num(prev =  1, sens = 1, spec = NA, fart = NA)  # => NAs + warning (NAs)
init_num(1, 1, .52, .50, 100)   # => NAs + warning (complements beyond range)

}
\seealso{
\code{\link{num}} contains basic numeric parameters;
\code{\link{pal}} contains current color settings;
\code{\link{txt}} contains current text settings;
\code{\link{freq}} contains current frequency information;
\code{\link{comp_freq}} computes frequencies from probabilities;
\code{\link{prob}} contains current probability information;
\code{\link{comp_prob}} computes current probability information;
\code{\link{is_valid_prob_set}} verifies sets of probability inputs;
\code{\link{is_extreme_prob_set}} verifies sets of extreme probabilities;
\code{\link{comp_min_N}} computes a suitable minimum population size \code{\link{N}}.

Other functions initializing scenario information: \code{\link{init_pal}},
  \code{\link{init_txt}}, \code{\link{riskyr}}
}
\concept{functions initializing scenario information}
