% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/init_freq.R
\docType{data}
\name{cond_false}
\alias{cond_false}
\title{Number of individuals for which the condition is false.}
\format{
An object of class \code{numeric} of length 1.
}
\usage{
cond_false
}
\description{
\code{cond_false} is a frequency that describes the
number of individuals in the current population \code{\link{N}}
for which the condition is \code{FALSE} (i.e., actually false cases).
}
\details{
Key relationships:

\enumerate{

\item to probabilities:
The frequency of \code{cond_false} individuals depends on the population size \code{\link{N}} and
the complement of the condition's prevalence \code{1 - \link{prev}} and is split further into two subsets of
\code{\link{fa}} by the false alarm rate \code{\link{fart}} and
\code{\link{cr}} by the specificity \code{\link{spec}}.

Perspectives:

\enumerate{
  \item by condition:

  The frequency \code{\link{cond_false}} is determined by the population size \code{\link{N}} times the complement of the prevalence \code{(1 - \link{prev})}:

  \code{\link{cond_false}= \link{N} x (1 - \link{prev})}

  \item by decision:

  a. The frequency \code{\link{fa}} is determined by \code{\link{cond_false}} times the false alarm rate \code{\link{fart} = (1 - \link{spec})}
  (aka. \code{\link{FPR}}):

  \code{\link{fa} = \link{cond_false} x \link{fart} = \link{cond_false} x (1 - \link{spec}) }


  b. The frequency \code{\link{cr}} is determined by \code{\link{cond_false}} times the specificity \code{\link{spec} = (1 - \link{fart})}:

  \code{\link{cr}  =  \link{cond_false} x \link{spec}  =  \link{cond_false} x (1 - \link{fart}) }

}

  \item to other frequencies:
  In a population of size \code{\link{N}} the following relationships hold:

  \itemize{

    \item \code{\link{N} = \link{cond_true} + \link{cond_false}} (by condition)

    \item \code{\link{N} = \link{dec_pos} + \link{dec_neg}} (by decision)

    \item \code{\link{N} = \link{dec_cor} + \link{dec_err}} (by correspondence of decision to condition)

    \item \code{\link{N} = \link{hi} + \link{mi} + \link{fa} + \link{cr}} (by condition x decision)
  }
}

Current frequency information is computed by
\code{\link{comp_freq}} and contained in a list
\code{\link{freq}}.
}
\examples{
cond_false <- 1000 * .90  # => sets cond_false to 90\% of 1000 = 900 cases.
is_freq(cond_false)       # => TRUE
is_prob(cond_false)       # => FALSE, as cond_false is no probability [but (1 - prev) and spec are]
}
\references{
Consult \href{https://en.wikipedia.org/wiki/Confusion_matrix}{Wikipedia: Confusion matrix} for additional information.
}
\seealso{
\code{\link{is_freq}} verifies frequencies;
\code{\link{num}} contains basic numeric parameters;
\code{\link{init_num}} initializes basic numeric parameters;
\code{\link{freq}} contains current frequency information;
\code{\link{comp_freq}} computes current frequency information;
\code{\link{prob}} contains current probability information;
\code{\link{comp_prob}} computes current probability information.

Other frequencies: 
\code{\link{N}},
\code{\link{cond_true}},
\code{\link{cr}},
\code{\link{dec_cor}},
\code{\link{dec_err}},
\code{\link{dec_neg}},
\code{\link{dec_pos}},
\code{\link{fa}},
\code{\link{hi}},
\code{\link{mi}}
}
\concept{frequencies}
\keyword{datasets}
