% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stack.R
\name{return_from}
\alias{return_from}
\alias{return_to}
\title{Jump to or from a frame}
\usage{
return_from(frame, value = NULL)

return_to(frame, value = NULL)
}
\arguments{
\item{frame}{An environment, a frame object, or any object with an
\code{\link[=get_env]{get_env()}} method. The environment should be an evaluation
environment currently on the stack.}

\item{value}{The return value.}
}
\description{
While \code{\link[base:return]{base::return()}} can only return from the current local
frame, these two functions will return from any frame on the
current evaluation stack, between the global and the currently
active context. They provide a way of performing arbitrary
non-local jumps out of the function currently under evaluation.
}
\details{
\code{return_from()} will jump out of \code{frame}. \code{return_to()} is a bit
trickier. It will jump out of the frame located just before \code{frame}
in the evaluation stack, so that control flow ends up in \code{frame},
at the location where the previous frame was called from.

These functions should only be used rarely. These sort of non-local
gotos can be hard to reason about in casual code, though they can
sometimes be useful. Also, consider to use the condition system to
perform non-local jumps.
}
\examples{
# Passing fn() evaluation frame to g():
fn <- function() {
  val <- g(get_env())
  cat("g returned:", val, "\\n")
  "normal return"
}
g <- function(env) h(env)

# Here we return from fn() with a new return value:
h <- function(env) return_from(env, "early return")
fn()

# Here we return to fn(). The call stack unwinds until the last frame
# called by fn(), which is g() in that case.
h <- function(env) return_to(env, "early return")
fn()
}
