% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/call.R
\name{call_modify}
\alias{call_modify}
\title{Modify the arguments of a call}
\usage{
call_modify(.call, ..., .homonyms = c("keep", "first", "last", "error"),
  .standardise = NULL, .env = caller_env())
}
\arguments{
\item{.call}{Can be a call, a formula quoting a call in the
right-hand side, or a frame object from which to extract the call
expression.}

\item{...}{<\link[=dyn-dots]{dynamic}> Named or unnamed expressions
(constants, names or calls) used to modify the call. Use \code{\link[=zap]{zap()}}
to remove arguments. Empty arguments are preserved.}

\item{.homonyms}{How to treat arguments with the same name. The
default, \code{"keep"}, preserves these arguments. Set \code{.homonyms} to
\code{"first"} to only keep the first occurrences, to \code{"last"} to keep
the last occurrences, and to \code{"error"} to raise an informative
error and indicate what arguments have duplicated names.}

\item{.standardise, .env}{Soft-deprecated as of rlang 0.3.0. Please
call \code{\link[=call_standardise]{call_standardise()}} manually.}
}
\value{
A quosure if \code{.call} is a quosure, a call otherwise.
}
\description{
If you are working with a user-supplied call, make sure the
arguments are standardised with \code{\link[=call_standardise]{call_standardise()}} before
modifying the call.
}
\section{Life cycle}{

\itemize{
\item The \code{.standardise} argument is deprecated as of rlang 0.3.0.
\item In rlang 0.2.0, \code{lang_modify()} was deprecated and renamed to
\code{call_modify()}. See lifecycle section in \code{\link[=call2]{call2()}} for more about
this change.
}
}

\examples{
call <- quote(mean(x, na.rm = TRUE))

# Modify an existing argument
call_modify(call, na.rm = FALSE)
call_modify(call, x = quote(y))

# Remove an argument
call_modify(call, na.rm = zap())

# Add a new argument
call_modify(call, trim = 0.1)

# Add an explicit missing argument:
call_modify(call, na.rm = )

# Supply a list of new arguments with `!!!`
newargs <- list(na.rm = NULL, trim = 0.1)
call <- call_modify(call, !!!newargs)
call

# Remove multiple arguments by splicing zaps:
newargs <- rep_named(c("na.rm", "trim"), list(zap()))
call <- call_modify(call, !!!newargs)
call


# Modify the `...` arguments as if it were a named argument:
call <- call_modify(call, ... = )
call

call <- call_modify(call, ... = zap())
call


# When you're working with a user-supplied call, standardise it
# beforehand because it might contain unmatched arguments:
user_call <- quote(matrix(x, nc = 3))
call_modify(user_call, ncol = 1)

# Standardising applies the usual argument matching rules:
user_call <- call_standardise(user_call)
user_call
call_modify(user_call, ncol = 1)


# You can also modify quosures inplace:
f <- quo(matrix(bar))
call_modify(f, quote(foo))


# By default, arguments with the same name are kept. This has
# subtle implications, for instance you can move an argument to
# last position by removing it and remapping it:
call <- quote(foo(bar = , baz))
call_modify(call, bar = NULL, bar = missing_arg())

# You can also choose to keep only the first or last homonym
# arguments:
args <-  list(bar = NULL, bar = missing_arg())
call_modify(call, !!!args, .homonyms = "first")
call_modify(call, !!!args, .homonyms = "last")
}
