% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lc.R
\name{getMarked}
\alias{getMarked}
\title{Get currently marked elements}
\usage{
getMarked(chartId = NULL, layerId = NULL)
}
\arguments{
\item{chartId}{An ID of the chart.}

\item{layerId}{An ID of the layer. This argument is required, if the chart has more
than one layer.}
}
\value{
a vector of indices or, in case of heatmaps, an \emph{n x 2} matrix were first and
second columns contain, respectively, row and column indices of the marked cells.
}
\description{
\code{getMarked} returns indices of the chart's elements that are currently
marked. To mark elements select them with you mouse while pressing the \emph{Shift} key.
Double click on the chart while pressing the \emph{Shift} key will unmark all the
elements.
}
\examples{
\donttest{data(iris)

lc_scatter(dat(x = iris$Sepal.Length, y = iris$Petal.Length))

#now mark some points by selecting them with your mouse with Shift pressed

getMarked("Chart1")}

}
