% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lc.R
\name{setProperties}
\alias{setProperties}
\title{Set properties of the chart}
\usage{
setProperties(data, id, layerId = NULL)
}
\arguments{
\item{data}{Set of properties to be redefined for this layer or chart. Created by \code{\link{dat}}
function.}

\item{id}{ID of the chart, whose properties you want to redefine.}

\item{layerId}{ID of the layer, whose properties you want to redefine. If the chart has a single
layer or doesn't have layers, default value (which is NULL) can be used.}
}
\description{
Changes already defined properties or sets the new ones for an
existing chart.
}
\examples{
\donttest{data("iris")
lc_scatter(dat(x = iris$Sepal.Length, y = iris$Sepal.Width), id = "irisScatter")
setProperties(dat(symbolValue = iris$Species, y = iris$Petal.Length), id = "irisScatter")
updateCharts("irisScatter")

lc_line(dat(x = iris$Sepal.Length, y = iris$Petal.Length), id = "irisScatter", layerId = "line")
setProperties(dat(colour = "red"), id = "irisScatter", layerId = "line")
updateCharts("irisScatter")}

}
