% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mincostflow.R
\name{MinCostFlow}
\alias{MinCostFlow}
\title{Solver for MinCostFlow}
\usage{
MinCostFlow(
  arcSources,
  arcTargets,
  arcCapacities,
  arcCosts,
  nodeSupplies,
  numNodes,
  algorithm = "NetworkSimplex"
)
}
\arguments{
\item{arcSources}{Vector corresponding to the source nodes of a graph's
edges}

\item{arcTargets}{Vector corresponding to the destination nodes of a graph's
edges}

\item{arcCapacities}{Vector corresponding to the capacities of nodes of a
graph's edges}

\item{arcCosts}{Vector corresponding to the capacities of nodes of a graph's
edges}

\item{nodeSupplies}{Vector corresponding to the supplies of each node}

\item{numNodes}{The number of nodes in the graph}

\item{algorithm}{Choices of algorithm include "NetworkSimplex",
"CostScaling", "CapacityScaling", and "CycleCancelling". NetworkSimplex is
the default.}
}
\value{
A list containing three entries: 1) A vector corresponding to the
  flows of arcs in the graph, 2) A vector of potentials of the graph's
  nodes, 3) the total cost of the flows in the graph, i.e. the mincostflow
  value, and 4) LEMON's feasibility type, demonstrating how feasible the
  graph problem is, one of "INFEASIBLE", "OPTIMAL", and "UNBOUNDED"
}
\description{
Finds the minimum cost flow of a directed graph.
}
\details{
For details on LEMON's implementation, including differences between the
algorithms, see \url{https://lemon.cs.elte.hu/pub/doc/1.3.1/a00612.html}.
}
