% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mincut.R
\name{MinCut}
\alias{MinCut}
\title{Solver for MinCut}
\usage{
MinCut(
  arcSources,
  arcTargets,
  arcWeights,
  numNodes,
  algorithm = "NagamochiIbaraki"
)
}
\arguments{
\item{arcSources}{Vector corresponding to the source nodes of a graph's
edges}

\item{arcTargets}{Vector corresponding to the destination nodes of a graph's
edges}

\item{arcWeights}{Vector corresponding to the weights of a graph's arcs}

\item{numNodes}{The number of nodes in the graph}

\item{algorithm}{Choices of algorithm include "NagamochiIbaraki" and
"HaoOrlin". "NagamochiIbaraki" is the default.}
}
\value{
A list containing three entries: 1) The value of the minimum cut in
  the graph, and 2) A vector of nodes in the first partition, and 3) A
  vector of nodes in the second partition. GomoryHu calculates a Gomory-Hu
  Tree and returns a list containing three entries: 1) A vector of
  predecessor nodes of each node in the graph, and 2) A vector of weights of
  the predecessor edge of each node, and 3) A vector of distances from the
  root node to each node.
}
\description{
Finds the minimum cut on graphs. NagamochiIbaraki calculates the min cut
value and edges in undirected graphs,while HaoOrlin calculates the min cut value
and edges in directed graphs.
}
\details{
For details on LEMON's implementation, including differences between the
algorithms, see \url{https://lemon.cs.elte.hu/pub/doc/1.3.1/a00613.html}.
}
