% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MinContrastEstim.R
\name{MinContrastEstim}
\alias{MinContrastEstim}
\title{Statistical estimator of sigma, alpha and H in low frequency setting based on minimal contrast estimation comparing the empirical characteristic function with the true one}
\usage{
MinContrastEstim(path, k, p, order_GH)
}
\arguments{
\item{path}{low frequency sample path from which the parameters should be estimated.}

\item{k}{order of increments.}

\item{p}{a positive number, the power used for \code{\link{H_hat}}.}

\item{order_GH}{number of weights in the Gauss-Hermite approximation of the integral, see the \code{gauss.hermite} function from the spatstat package.}
}
\description{
Estimates H using the \code{\link{H_hat}} function while sigma and alpha are obtained via
\deqn{argmin_{\sigma, \alpha} \int_{0}^{\infty} (\varphi_n(t) - \varphi_{\sigma, \alpha, H_hat}(t))^2 exp(-t^2) d t},
where \eqn{\varphi_n} is the empirical characteristic function, see \code{\link{phi}}, and \eqn{\varphi_{\sigma, \alpha, H_hat}} is the characteristic function of the kth order increment \eqn{\Delta_{k, k} X}, see also \code{\link{increments}}.
}
\details{
This algorithm approximates the above integral using Gauss-Hermite quadrature and uses the \code{L-BFGS-B} method from the \code{optim} function to minimize over the parameters sigma and alpha.
Due to numerical problems estimation of sigma below 0.01 and alpha or H below 0.05 is currently not possible.
}
\examples{
m0 = 256
M0 = 600
alpha0 = 1.8
H0 = 0.8
sigma0 = 0.3
n = 100
X <- path(N = n, m = m0, M = M0, alpha = alpha0, H = H0, sigma = sigma0, freq = 'L')$lfsm
MinContrastEstim(path = X, k = 2, p = 0.4, order_GH = 8)

}
\references{
\insertRef{LP2019}{rlfsm}
}
