% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NuggetKrigingClass.R
\name{logMargPostFun.NuggetKriging}
\alias{logMargPostFun.NuggetKriging}
\alias{logMargPostFun,NuggetKriging,NuggetKriging-method}
\title{Compute the log-marginal posterior of a kriging model, using the
prior XXXY.}
\usage{
\method{logMargPostFun}{NuggetKriging}(object, theta_alpha, grad = FALSE, bench = FALSE, ...)
}
\arguments{
\item{object}{S3 NuggetKriging object.}

\item{theta_alpha}{Numeric vector of correlation range and variance over variance plus nugget parameters at
which the function is to be evaluated.}

\item{grad}{Logical. Should the function return the gradient
(w.r.t theta_alpha)?}

\item{bench}{Logical. Should the function display benchmarking output}

\item{...}{Not used.}
}
\value{
The value of the log-marginal posterior computed for the
    given vector \eqn{\boldsymbol{theta_alpha}}{\theta,\frac{\sigma^2}{\sigma^2+nugget}}.
}
\description{
Compute the log-marginal posterior of a kriging model, using the
prior XXXY.
}
\examples{
f <- function(x) 1 - 1 / 2 * (sin(12 * x) / (1 + x) + 2 * cos(7 * x) * x^5 + 0.7)
set.seed(123)
X <- as.matrix(runif(10))
y <- f(X) + 0.1 * rnorm(nrow(X))

k <- NuggetKriging(y, X, "matern3_2", objective="LMP")
print(k)

theta0 = k$theta()
lmp_alpha <- function(alpha) k$logMargPostFun(cbind(theta0,alpha))$logMargPost
a <- seq(from = 0.9, to = 1.0, length.out = 101)
plot(a, Vectorize(lmp_alpha)(a), type = "l",xlim=c(0.9,1))
abline(v = k$sigma2()/(k$sigma2()+k$nugget()), col = "blue")

alpha0 = k$sigma2()/(k$sigma2()+k$nugget())
lmp_theta <- function(theta) k$logMargPostFun(cbind(theta,alpha0))$logMargPost
t <- seq(from = 0.001, to = 2, length.out = 101)
plot(t, Vectorize(lmp_theta)(t), type = 'l')
abline(v = k$theta(), col = "blue")

lmp <- function(theta_alpha) k$logMargPostFun(theta_alpha)$logMargPost
t <- seq(from = 0.4, to = 0.6, length.out = 51)
a <- seq(from = 0.9, to = 1, length.out = 51)
contour(t,a,matrix(ncol=length(t),lmp(expand.grid(t,a))),
 nlevels=50,xlab="theta",ylab="sigma2/(sigma2+nugget)")
points(k$theta(),k$sigma2()/(k$sigma2()+k$nugget()),col='blue')
}
\references{
XXXY A reference describing the model (prior, ...)
}
\seealso{
\code{\link[RobustGaSP]{rgasp}} in the RobustGaSP package.
}
\author{
Yann Richet \email{yann.richet@irsn.fr}
}
