% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rliger.R
\name{calcARI}
\alias{calcARI}
\title{Calculate adjusted Rand index}
\usage{
calcARI(object, clusters.compare, verbose = TRUE)
}
\arguments{
\item{object}{\code{liger} object. Should run quantileAlignSNF before calling.}

\item{clusters.compare}{Clustering with which to compare (named vector).}

\item{verbose}{Print messages (TRUE by default)}
}
\value{
Adjusted Rand index value.
}
\description{
Computes adjusted Rand index for \code{liger} clustering and external clustering.
The Rand index ranges from 0 to 1, with 0 indicating no agreement between clusterings and 1
indicating perfect agreement.
}
\examples{
ligerex <- createLiger(list(ctrl = ctrl, stim = stim))
ligerex <- normalize(ligerex)
ligerex <- selectGenes(ligerex)
ligerex <- scaleNotCenter(ligerex)
# Specification for minimal example run time, not converging
ligerex <- optimizeALS(ligerex, k = 5, max.iters = 1)
ligerex <- quantile_norm(ligerex)
agreement <- calcARI(ligerex, ligerex@clusters)
}
