% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rliger.R
\name{optimizeSubset}
\alias{optimizeSubset}
\title{Perform factorization for subset of data}
\usage{
optimizeSubset(
  object,
  cell.subset = NULL,
  cluster.subset = NULL,
  lambda = NULL,
  thresh = 1e-04,
  max.iters = 100,
  datasets.scale = NULL
)
}
\arguments{
\item{object}{\code{liger} object. Should call optimizeALS before calling.}

\item{cell.subset}{List of cell names to retain from each dataset (same length as number of
datasets).}

\item{cluster.subset}{Clusters for which to keep cells (ie. c(1, 5, 6)). Should pass in either
cell.subset or cluster.subset but not both.}

\item{lambda}{Regularization parameter. By default, uses last used lambda.}

\item{thresh}{Convergence threshold. Convergence occurs when |obj0-obj|/(mean(obj0,obj)) < thresh
(default 1e-4).}

\item{max.iters}{Maximum number of block coordinate descent iterations to perform (default 100).}

\item{datasets.scale}{Names of datasets to rescale after subsetting (default NULL).}
}
\value{
\code{liger} object with H, W, and V slots reset. Scale.data
  (if desired) will also be updated to reflect the subset.
}
\description{
Uses an efficient strategy for updating that takes advantage of the information in the existing
factorization. Can use either cell names or cluster names to subset. For more basic subsetting
functionality (without automatic optimization), see subsetLiger.
}
\examples{
ligerex <- createLiger(list(ctrl = ctrl, stim = stim))
ligerex <- normalize(ligerex)
ligerex <- selectGenes(ligerex)
ligerex <- scaleNotCenter(ligerex)
\donttest{
# Assume we are performing the factorization
# Specification for minimal example run time, not converging.
ligerex <- optimizeALS(ligerex, k = 5, max.iters = 1)
# Preparing subset with random sampling.
# Subset can also be obtained with prior knowledge from metadata.
cell_names_1 <- sample(rownames(ligerex@H[[1]]), 20)
cell_names_2 <- sample(rownames(ligerex@H[[2]]), 20)

ligerex2 <- optimizeSubset(ligerex, cell.subset = list(cell_names_1, cell_names_2),
                           max.iters = 1)
}
}
