% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rliger.R
\name{plotGeneViolin}
\alias{plotGeneViolin}
\title{Plot violin plots for gene expression}
\usage{
plotGeneViolin(
  object,
  gene,
  methylation.indices = NULL,
  by.dataset = TRUE,
  return.plots = FALSE
)
}
\arguments{
\item{object}{\code{liger} object.}

\item{gene}{Gene for which to plot relative expression.}

\item{methylation.indices}{Indices of datasets in object with methylation data (this data is not
magnified and put on log scale).}

\item{by.dataset}{Plots gene expression for each dataset separately (default TRUE).}

\item{return.plots}{Return ggplot objects instead of printing directly to console (default
FALSE).}
}
\value{
List of ggplot plot objects (only if return.plots TRUE, otherwise prints plots to
  console).
}
\description{
Generates violin plots of expression of specified gene for each dataset.
}
\examples{
ligerex <- createLiger(list(ctrl = ctrl, stim = stim))
ligerex <- normalize(ligerex)
ligerex <- selectGenes(ligerex)
ligerex <- scaleNotCenter(ligerex)
ligerex <- optimizeALS(ligerex, k = 5, max.iter = 2)
ligerex <- quantile_norm(ligerex)
ligerex <- louvainCluster(ligerex)
plotGeneViolin(ligerex, "CD74", by.dataset = FALSE)
plotGeneViolin(ligerex, "CD74")
}
