% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/import.R
\name{createLigerDataset}
\alias{createLigerDataset}
\title{Create in-memory ligerDataset object}
\usage{
createLigerDataset(
  rawData = NULL,
  modal = c("default", "rna", "atac", "spatial", "meth"),
  normData = NULL,
  scaleData = NULL,
  featureMeta = NULL,
  ...
)
}
\arguments{
\item{rawData, normData, scaleData}{A \code{\link[Matrix]{dgCMatrix-class}}
object for the raw or normalized expression count or a dense matrix of scaled
variable gene expression, respectively. Default \code{NULL} for all three but
at lease one has to be specified.}

\item{modal}{Name of modality for this dataset. Currently options of
\code{"default"}, \code{"rna"}, \code{"atac"}, \code{"spatial"} and
\code{"meth"} are supported. Default \code{"default"}.}

\item{featureMeta}{Data frame of feature metadata. Default \code{NULL}.}

\item{...}{Additional slot data. See \linkS4class{ligerDataset} for detail.
Given values will be directly placed at corresponding slots.}
}
\description{
Create in-memory ligerDataset object
}
\examples{
ctrl.raw <- rawData(pbmc, "ctrl")
ctrl.ld <- createLigerDataset(ctrl.raw)
}
\seealso{
\linkS4class{ligerDataset}, \linkS4class{ligerATACDataset},
\linkS4class{ligerSpatialDataset}, \linkS4class{ligerMethDataset}
}
