% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clustering.R
\name{louvainCluster-deprecated}
\alias{louvainCluster-deprecated}
\title{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#superseded}{\figure{lifecycle-superseded.svg}{options: alt='[Superseded]'}}}{\strong{[Superseded]}} Louvain algorithm for community detection}
\arguments{
\item{object}{\code{liger} object. Should run quantile_norm before calling.}

\item{k}{The maximum number of nearest neighbours to compute. (default 20)}

\item{resolution}{Value of the resolution parameter, use a value above
(below) 1.0 if you want to obtain a larger (smaller) number of communities.
(default 1.0)}

\item{prune}{Sets the cutoff for acceptable Jaccard index when
computing the neighborhood overlap for the SNN construction. Any edges with
values less than or equal to this will be set to 0 and removed from the SNN
graph. Essentially sets the strigency of pruning (0 --- no pruning, 1 ---
prune everything). (default 1/15)}

\item{eps}{The error bound of the nearest neighbor search. (default 0.1)}

\item{nRandomStarts}{Number of random starts. (default 10)}

\item{nIterations}{Maximal number of iterations per random start. (default
100)}

\item{random.seed}{Seed of the random number generator. (default 1)}

\item{verbose}{Print messages (TRUE by default)}

\item{dims.use}{Indices of factors to use for clustering. Default \code{NULL}
uses all available factors.}
}
\value{
\code{object} with refined cluster assignment updated in
\code{"louvain_cluster"} variable in \code{cellMeta} slot. Can be fetched
with \code{object$louvain_cluster}
}
\description{
After quantile normalization, users can additionally run the Louvain
algorithm for community detection, which is widely used in single-cell
analysis and excels at merging small clusters into broad cell classes.
}
\seealso{
\code{\link{rliger-deprecated}}
}
