% Generated by roxygen2 (4.0.2): do not edit by hand
\name{qn}
\alias{qn}
\title{Optimal and Data-Driven Moving Average Lag q}
\usage{
qn(x)
}
\arguments{
\item{x}{a numeric vector or univariate time series.}
}
\value{
\item{qn}{the optimal moving average lag \eqn{q}.}
}
\description{
Determines the optimal and data-driven moving average lag \eqn{q}.
}
\details{
For univariate time series \eqn{x[t]}, the moving average filter is defined as
\deqn{mhat[t] = \sum x[t]/(2q+1)} for \eqn{q + 1 \le t \le n + q}. The optimal and
data-driven moving average lag \eqn{q} can be determined by using the rule-of-thumb
estimator proposed in Section 3 of D. Qiu \emph{et al.} (2013). It is determined by
sample size \eqn{n}, variance \eqn{\gamma(0)} and curvature \eqn{m''} of the univariate
series, where \eqn{m''} is the second derivative of an unknown nonparameteric trend
function \eqn{m(t)}. To obtain the preliminary estimators of variance \eqn{\gamma(0)} and
curvature \eqn{m''}, \eqn{m(t)} can be initially fitted by a cubic polynomial model.
See L. Yang and R. Tscherning (1999) for more details. For the case when \eqn{q > n},
the optimal moving average lag \eqn{q} is set to be an integer part of \eqn{n^{4/5}/2}.
}
\examples{
## load the global temperature data:
## first column is time and second column is temperature.
data(globtemp)
(q.n <- qn(globtemp))
}
\author{
Debin Qiu
}
\references{
D. Qiu, Q. Shao, and L. Yang (2013), Efficient inference for autoregressive coeficient in
the presence of trend. \emph{Journal of Multivariate Analysis} 114, 40-53.

L. Yang, R. Tscherning (1999), Multivariate bandwidth selection for local linear
regression. \emph{Journal of the Royal Statistical Society. Series B. Statistical
Methodology} 61, 793-815.
}

