#' Run `make`` in the system
#'
#' This function executes the `make` command in order to re-build all dependencies, accordingly to `Makefile`
#' generated by [makefile()].
#'
#' @param ... Command-line arguments passed to the `make` command
#' @return Exit status of the command, see [base::system2()] for details.
#' @seealso [makefile()], [rmakeSkeleton()]
#' @author Michal Burda
#' @examples
#' \dontrun{
#'   make()        # make all
#'   make('clean') # make the 'clean' task
#'   make('-j', 4) # make with 4 processes in parallell
#' }
#' @export
make <- function(...) {
  args <- as.character(c(...))
  system2('make', args=args)
}
