% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/pandoc.R
\name{pandoc_available}
\alias{pandoc_available}
\alias{pandoc_version}
\title{Check pandoc availabilty and version}
\usage{
pandoc_available(version = NULL)

pandoc_version()
}
\arguments{
\item{version}{Required version of pandoc}
}
\value{
\code{pandoc_available} returns a logical indicating whether the
  required version of pandoc is available. \code{pandoc_version} returns a
  \code{\link[base]{numeric_version}} with the version of pandoc found.
}
\description{
Determine whether pandoc is currently available on the system (optionally
checking for a specific version or greater). Determine the specific version
of pandoc available.
}
\details{
The system path as well as the version of pandoc shipped with RStudio (if
running under RStudio) are scanned for pandoc and the highest version
available is used.
}
\examples{
\dontrun{
library(rmarkdown)

if (pandoc_available())
  cat("pandoc", as.character(pandoc_version()), "is available!\\n")

if (pandoc_available("1.12.3"))
  cat("requried version of pandoc is available!\\n")
}
}

