/*
 * Decompiled with CFR 0.152.
 */
package dmLab.array.loader.fileLoader;

import dmLab.array.Array;
import dmLab.array.functions.DiscFunctions;
import dmLab.array.loader.fileLoader.FileType;
import dmLab.array.loader.fileLoader.NullLabels;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;

public abstract class FileLoader {
    private FileType fileType;
    private BufferedReader fileReader;
    private String fileName;
    protected int eventsNumber;
    protected int attributesNumber;
    protected int ignoredAttributesNumber;
    public char separator = (char)44;
    protected NullLabels nullLabels;
    protected String defaultNullLabel = "?";
    public boolean trimComments = true;
    protected boolean[] ignoredAttributeMask;
    protected Array myArray;
    protected String commentChar = "#";

    public FileLoader() {
        this.init();
    }

    public final void init() {
        this.fileReader = null;
        this.fileType = new FileType();
        this.nullLabels = new NullLabels(5);
        this.fileName = "";
        this.ignoredAttributeMask = null;
        this.eventsNumber = 0;
        this.attributesNumber = 0;
        this.ignoredAttributesNumber = 0;
        this.privateInitializator();
    }

    /*
     * WARNING - void declaration
     */
    public final boolean loadFile(Array array, String inputFileName) {
        void var2_2;
        boolean bl;
        FileLoader fileLoader;
        this.myArray = fileLoader;
        if (!this.openFile(inputFileName)) {
            return false;
        }
        if (!this.parseInputFile(this.fileReader)) {
            System.err.println("Error Parsing file. File: " + this.fileName);
            this.closeFile();
            return false;
        }
        fileLoader = this;
        System.out.println("attributes: " + fileLoader.attributesNumber + " events: " + fileLoader.eventsNumber);
        if (fileLoader.attributesNumber == 0) {
            System.err.println("No attributes defined in input file. File: " + fileLoader.fileName);
            bl = false;
        } else if (fileLoader.eventsNumber == 0) {
            System.err.println("No events defined in input file. File: " + fileLoader.fileName);
            bl = false;
        } else {
            bl = true;
        }
        if (!bl) {
            return false;
        }
        this.closeFile();
        this.myArray.init(this.attributesNumber, this.eventsNumber);
        this.ignoredAttributeMask = new boolean[this.attributesNumber + this.ignoredAttributesNumber];
        if (!this.openFile((String)var2_2)) {
            return false;
        }
        if (!this.readInputFile(this.fileReader)) {
            System.err.println("Error reading file. File: " + this.fileName);
            this.closeFile();
            return false;
        }
        this.closeFile();
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private boolean openFile(String inputFileName) {
        Object object = DiscFunctions.getFileExtension(inputFileName);
        this.fileName = FileType.toType((String)object) != -1 ? inputFileName : String.valueOf(inputFileName) + "." + this.fileType.getTypeStr();
        object = new File(this.fileName);
        if (!((File)object).exists()) {
            void var1_1;
            System.err.println("File does not exist. File: " + (String)var1_1);
            return false;
        }
        try {
            this.fileReader = new BufferedReader(new FileReader(this.fileName));
        }
        catch (Exception exception) {
            System.err.println("Error opening file. File: " + this.fileName);
            return false;
        }
        return true;
    }

    private boolean closeFile() {
        try {
            this.fileReader.close();
        }
        catch (Exception exception) {
            System.err.println("Error closing file. File: " + this.fileName);
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    protected final String trimComments(String inputLine) {
        void var1_1;
        if (!this.trimComments) {
            return inputLine;
        }
        if (inputLine == null) {
            return null;
        }
        if (inputLine.indexOf(this.commentChar) == -1) {
            return inputLine.trim();
        }
        return inputLine.substring(0, var1_1.indexOf(this.commentChar)).trim();
    }

    protected final boolean loadEvent(String inputLine, int row) {
        int column = 0;
        String[] list = DiscFunctions.tokenizeString(inputLine, new char[]{this.separator}, false);
        if (list.length != this.attributesNumber + this.ignoredAttributesNumber) {
            System.err.println("Number of values does not equal to attributes number.");
            return false;
        }
        int i = 0;
        while (i < this.ignoredAttributeMask.length) {
            if (!this.ignoredAttributeMask[i]) {
                String value = list[i];
                if (this.nullLabels.containsIgnoreCase(value)) {
                    value = this.defaultNullLabel;
                }
                if (value.length() != 0) {
                    if (!this.myArray.writeValueStr(column, row, value)) {
                        System.err.println("Error loading value. Attribute: " + this.myArray.attributes[column].name + " (#" + i + ") value: " + value);
                        return false;
                    }
                    ++column;
                } else {
                    System.err.println("Empty Value! Attribute: " + this.myArray.attributes[column].name + " (#" + i + ")");
                    return false;
                }
            }
            ++i;
        }
        return true;
    }

    protected abstract boolean parseInputFile(BufferedReader var1);

    protected abstract boolean readInputFile(BufferedReader var1);

    protected abstract boolean privateInitializator();
}

