/*
 * Decompiled with CFR 0.152.
 */
package dmLab.classifier.ensemble;

import dmLab.array.FArray;
import dmLab.classifier.Classifier;
import dmLab.classifier.Prediction;
import dmLab.classifier.bayesNet.BayesNetClassifier;
import dmLab.classifier.ensemble.EnsembleDecisionWeights;
import dmLab.classifier.ensemble.EnsembleParams;
import dmLab.classifier.hyperPipes.HyperPipesClassifier;
import dmLab.classifier.j48.J48Classifier;
import dmLab.classifier.knn.KNNClassifier;
import dmLab.classifier.nb.NBClassifier;
import dmLab.classifier.randomForest.RandomForestClassifier;
import dmLab.classifier.ripper.RipperClassifier;
import dmLab.classifier.sliq.SliqClassifier;
import dmLab.classifier.svm.SVMClassifier;
import dmLab.mcfs.attributesRI.AttributesRI;
import dmLab.utils.cmatrix.ConfusionMatrix;
import dmLab.utils.list.FloatList;
import dmLab.utils.list.ObjectList;
import java.io.IOException;

public final class EnsembleClassifier
extends Classifier {
    private ObjectList en;
    private FloatList weights;
    private EnsembleParams cfg;

    public EnsembleClassifier() {
        this.label = labels[0];
        this.en = new ObjectList();
        this.weights = new FloatList();
        this.params = new EnsembleParams();
        this.cfg = (EnsembleParams)this.params;
        this.init();
    }

    @Override
    public final boolean init() {
        this.en = new ObjectList();
        this.en.add(new J48Classifier());
        this.en.add(new SliqClassifier());
        this.en.add(new RandomForestClassifier());
        this.en.add(new NBClassifier());
        this.en.add(new SVMClassifier());
        this.en.add(new KNNClassifier());
        this.en.add(new RipperClassifier());
        this.en.add(new BayesNetClassifier());
        this.en.add(new HyperPipesClassifier());
        EnsembleClassifier ensembleClassifier = this;
        ensembleClassifier.setWeights(ensembleClassifier.cfg.weights);
        this.normalizeWeights();
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public final String getSubClassifierName(int i) {
        if (i >= 0 && i < this.en.size()) {
            void var1_1;
            return ((Classifier)this.en.get((int)var1_1)).label;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private float normalizeWeights() {
        void var3_3;
        int size = this.weights.size();
        float sum = 0.0f;
        float newSum = 0.0f;
        int i = 0;
        while (i < size) {
            sum += this.weights.get(i);
            ++i;
        }
        i = 0;
        while (i < size) {
            if (this.weights.get(i) != 0.0f) {
                this.weights.set(i, this.weights.get(i) / sum);
            }
            newSum += this.weights.get(i);
            ++i;
        }
        return (float)var3_3;
    }

    public final int size() {
        return this.en.size();
    }

    public final boolean setWeights(float[] _weights) {
        if (_weights.length != this.en.size()) {
            return false;
        }
        this.weights = new FloatList();
        int i = 0;
        while (i < _weights.length) {
            this.weights.add(_weights[i]);
            ++i;
        }
        this.normalizeWeights();
        return true;
    }

    @Override
    public final String toString() {
        EnsembleClassifier ensembleClassifier = this;
        StringBuffer stringBuffer = new StringBuffer();
        int n = ensembleClassifier.en.size();
        int n2 = 0;
        while (n2 < n) {
            stringBuffer.append(((Classifier)ensembleClassifier.en.get((int)n2)).label).append(" = ").append(ensembleClassifier.weights.get(n2)).append('\n');
            ++n2;
        }
        stringBuffer.append('\n').append("ensemble.weights=[");
        n2 = 0;
        while (n2 < n) {
            stringBuffer.append(ensembleClassifier.weights.get(n2));
            if (n2 < n - 1) {
                stringBuffer.append(',');
            }
            ++n2;
        }
        stringBuffer.append(']').append('\n');
        return stringBuffer.toString();
    }

    @Override
    public final boolean train(FArray trainArray) {
        if (this.params.verbose) {
            System.out.println("Training...");
        }
        int classifiersNum = this.en.size();
        int i = 0;
        while (i < classifiersNum) {
            if (this.weights.get(i) != 0.0f) {
                ((Classifier)this.en.get(i)).train(trainArray);
                if (this.params.verbose) {
                    System.out.println("*** Classifier: " + ((Classifier)this.en.get((int)i)).label + " is trained ***");
                }
            }
            ++i;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean test(FArray testArray) {
        void var2_2;
        int interval;
        if (this.params.verbose) {
            System.out.println("Testing...");
        }
        long start = System.currentTimeMillis();
        this.confusionMatrix = new ConfusionMatrix(testArray.getColNames(true)[testArray.getDecAttrIdx()], testArray.getDecValues(), testArray.getDecValuesStr());
        int testEventsNumber = testArray.rowsNumber();
        int threshold = interval = (int)Math.ceil(0.1 * (double)testEventsNumber);
        this.predictions = new Prediction[testEventsNumber];
        EnsembleDecisionWeights ensembleDecisions = new EnsembleDecisionWeights(testArray.getDecValues());
        int classifiersNum = this.en.size();
        int i = 0;
        while (i < classifiersNum) {
            if (this.weights.get(i) != 0.0f) {
                ((Classifier)this.en.get(i)).test(testArray);
                if (this.params.verbose) {
                    System.out.println("*** Classifier: " + ((Classifier)this.en.get((int)i)).label + " is tested ***");
                }
            }
            ++i;
        }
        int decAttrIndex = testArray.getDecAttrIdx();
        int i2 = 0;
        while (i2 < testEventsNumber) {
            ensembleDecisions.cleanWeights();
            int j = 0;
            while (j < classifiersNum) {
                if (this.weights.get(j) != 0.0f) {
                    String currlabel = ((Classifier)this.en.get(j)).getPredictions()[i2].getLabel();
                    float currDecision = testArray.dictionary.toFloat(currlabel);
                    float currWeight = this.weights.get(j);
                    ensembleDecisions.add(currDecision, currWeight);
                }
                ++j;
            }
            float predictedDecision = ensembleDecisions.getMaxDecision();
            float realDecision = testArray.readValue(decAttrIndex, i2);
            this.confusionMatrix.add(realDecision, predictedDecision);
            String predictedClassName = testArray.dictionary.toString(predictedDecision);
            this.predictions[i2] = new Prediction(predictedClassName, null);
            if (i2 > threshold && threshold != 0) {
                if (this.params.verbose) {
                    System.out.print((int)(100.0 * (double)i2 / (double)testEventsNumber) + "% ");
                }
                threshold += interval;
            }
            ++i2;
        }
        if (this.params.verbose) {
            System.out.print("100% ");
        }
        long stop = System.currentTimeMillis();
        this.testingTime = (float)(stop - var2_2) / 1000.0f;
        if (this.params.verbose) {
            System.out.println(" Done!");
        }
        return true;
    }

    @Override
    public final boolean addImportances(AttributesRI[] importances) {
        return false;
    }

    @Override
    public final boolean saveDefinition(String path, String name) throws IOException {
        return false;
    }

    @Override
    public final boolean finish() {
        return true;
    }
}

