/*
 * Decompiled with CFR 0.152.
 */
package dmLab.experiment.ensembleOptimization;

import dmLab.array.functions.DiscFunctions;
import dmLab.classifier.Classifier;
import dmLab.classifier.ensemble.EnsembleClassifier;
import dmLab.experiment.classification.ClassificationBody;
import dmLab.utils.MathUtils;
import java.util.Random;

public class EnsembleExperiment {
    private ClassificationBody classification = new ClassificationBody(new Random(System.currentTimeMillis()));
    private double wAcc;

    public static void main(String[] args) {
        Object object = new EnsembleExperiment();
        object.run("data2_train_mcfs_out.arff", new float[]{1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f});
    }

    public EnsembleExperiment() {
        this.classification.loadParameters("classification.run");
        this.classification.classParams.debug = false;
        this.classification.classParams.verbose = false;
        this.classification.classParams.saveClassifier = false;
        this.classification.classParams.savePredictionResult = false;
        this.classification.classParams.validationType = 2;
        this.classification.classParams.classifier = Classifier.ENSEMBLE;
    }

    public final float run(String inputFileName, float[] _weights) {
        StringBuffer stringBuffer;
        ClassificationBody classificationBody;
        this.classification.classParams.inputFileName = classificationBody;
        this.classification.createClassifier();
        if (!((EnsembleClassifier)this.classification.classifier).setWeights((float[])stringBuffer)) {
            System.err.println("Error in weights setting!");
            return -1.0f;
        }
        this.classification.classifier.params.debug = false;
        this.classification.classifier.params.verbose = false;
        this.classification.loadArrays();
        this.classification.classifier.params.check(this.classification.inArray);
        this.wAcc = this.classification.run();
        if (this.classification.classParams.verbose) {
            classificationBody = this.classification;
            stringBuffer = new StringBuffer();
            if (classificationBody.resultConfMatrix != null) {
                stringBuffer.append("\n#######  FINAL RESULT  #######").append("\n");
                stringBuffer.append(classificationBody.classParams.repetitions + " repetition");
                if (classificationBody.classParams.repetitions > 1) {
                    stringBuffer.append("s has");
                } else {
                    stringBuffer.append(" have");
                }
                stringBuffer.append(" been processed.\n");
                stringBuffer.append(classificationBody.toStringCMatrix()).append("\n");
                int n = 1;
                if (classificationBody.classParams.validationType == 2) {
                    n = classificationBody.classParams.folds;
                }
                stringBuffer.append("Average Repetition time: " + DiscFunctions.format(classificationBody.experimentTime * (float)n, 2) + " s.").append("\n");
                stringBuffer.append("Average Experiment time: " + DiscFunctions.format(classificationBody.experimentTime, 2) + " s.").append("\n");
                stringBuffer.append("Average Learning time: " + DiscFunctions.format(classificationBody.learningTime, 2) + " s.").append("\n");
                stringBuffer.append("Average Testing time: " + DiscFunctions.format(classificationBody.testingTime, 2) + " s.").append("\n");
                if (classificationBody.accArray != null && classificationBody.wAccArray != null) {
                    stringBuffer.append("\n");
                    stringBuffer.append("Accuracy variance: " + DiscFunctions.format(MathUtils.variance(classificationBody.accArray), 5) + " s.").append("\n");
                    stringBuffer.append("wAccuracy variance: " + DiscFunctions.format(MathUtils.variance(classificationBody.wAccArray), 5) + " s.").append("\n");
                }
            }
            System.out.println(stringBuffer.toString());
        } else {
            System.out.println("wAcc: " + this.wAcc);
        }
        return (float)this.wAcc;
    }
}

