/*
 * Decompiled with CFR 0.152.
 */
package dmLab.gui.graphViewer.components;

import dmLab.array.functions.DiscFunctions;
import dmLab.experiment.ExperimentParams;
import dmLab.gui.graphViewer.GraphViewerBody;
import dmLab.gui.graphViewer.components.DoubleJSlider;
import dmLab.mcfs.attributesID.AttributesID;
import dmLab.mcfs.attributesRI.AttributesRI;
import dmLab.utils.fileFilters.ComplexFileFilter;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.text.DecimalFormat;
import javax.imageio.ImageIO;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public final class GraphViewerToolBar
extends JToolBar
implements ActionListener,
ChangeListener {
    private GraphViewerBody graphViever;
    private DoubleJSlider connectionWeightSlider;
    private JTextField connectionWeightLabel;
    private DoubleJSlider topSetSizeSlider;
    private JTextField topSetSizeLabel;
    private JFileChooser fileDialog;
    private JFileChooser saveBitmapFileDialog;
    private JCheckBox instantRedrawCheckBox;
    private JButton saveBitmapButton;
    private JButton drawButton;
    private JButton loadImportanceButton;
    private AttributesRI attributesImportance;

    public GraphViewerToolBar(GraphViewerBody graphViever) {
        GraphViewerToolBar graphViewerToolBar;
        this.graphViever = graphViewerToolBar;
        graphViewerToolBar = this;
        graphViewerToolBar.setLayout(null);
        graphViewerToolBar.setPreferredSize(new Dimension(700, 100));
        graphViewerToolBar.connectionWeightSlider = new DoubleJSlider();
        graphViewerToolBar.add(graphViewerToolBar.connectionWeightSlider);
        graphViewerToolBar.connectionWeightSlider.setBounds(10, 5, 450, 40);
        graphViewerToolBar.connectionWeightSlider.setLayout(null);
        graphViewerToolBar.connectionWeightSlider.addChangeListener(graphViewerToolBar);
        graphViewerToolBar.connectionWeightSlider.setToolTipText("minID (weight of connection)");
        graphViewerToolBar.connectionWeightLabel = new JTextField();
        graphViewerToolBar.add(graphViewerToolBar.connectionWeightLabel);
        graphViewerToolBar.connectionWeightLabel.setBounds(460, 10, 80, 30);
        graphViewerToolBar.connectionWeightLabel.setLayout(null);
        graphViewerToolBar.connectionWeightLabel.setText("");
        graphViewerToolBar.connectionWeightLabel.addActionListener(graphViewerToolBar);
        graphViewerToolBar.topSetSizeSlider = new DoubleJSlider();
        graphViewerToolBar.add(graphViewerToolBar.topSetSizeSlider);
        graphViewerToolBar.topSetSizeSlider.setBounds(10, 50, 450, 40);
        graphViewerToolBar.topSetSizeSlider.addChangeListener(graphViewerToolBar);
        graphViewerToolBar.topSetSizeSlider.setToolTipText("number of top features");
        graphViewerToolBar.topSetSizeLabel = new JTextField();
        graphViewerToolBar.add(graphViewerToolBar.topSetSizeLabel);
        graphViewerToolBar.topSetSizeLabel.setBounds(460, 55, 80, 30);
        graphViewerToolBar.topSetSizeLabel.setText("");
        graphViewerToolBar.topSetSizeLabel.addActionListener(graphViewerToolBar);
        graphViewerToolBar.loadImportanceButton = new JButton();
        graphViewerToolBar.add(graphViewerToolBar.loadImportanceButton);
        graphViewerToolBar.loadImportanceButton.setText("Load");
        graphViewerToolBar.loadImportanceButton.setBounds(545, 55, 90, 30);
        graphViewerToolBar.loadImportanceButton.setToolTipText("Load importance file...");
        graphViewerToolBar.loadImportanceButton.addActionListener(graphViewerToolBar);
        graphViewerToolBar.drawButton = new JButton();
        graphViewerToolBar.add(graphViewerToolBar.drawButton);
        graphViewerToolBar.drawButton.setText("Draw");
        graphViewerToolBar.drawButton.setToolTipText("Draw graph");
        graphViewerToolBar.drawButton.setBounds(545, 10, 90, 30);
        graphViewerToolBar.drawButton.addActionListener(graphViewerToolBar);
        graphViewerToolBar.saveBitmapButton = new JButton();
        graphViewerToolBar.add(graphViewerToolBar.saveBitmapButton);
        graphViewerToolBar.saveBitmapButton.setText("Save bitmap");
        graphViewerToolBar.saveBitmapButton.setToolTipText("Save image of the graph.");
        graphViewerToolBar.saveBitmapButton.setBounds(650, 55, 90, 30);
        graphViewerToolBar.saveBitmapButton.addActionListener(graphViewerToolBar);
        graphViewerToolBar.instantRedrawCheckBox = new JCheckBox();
        graphViewerToolBar.add(graphViewerToolBar.instantRedrawCheckBox);
        graphViewerToolBar.instantRedrawCheckBox.setText("Instant Drawing");
        graphViewerToolBar.instantRedrawCheckBox.setBounds(650, 10, 120, 30);
        this.initFileDialog();
        this.initSaveBitampFileDialog();
        this.cleanGUI();
    }

    public final void cleanGUI() {
        this.loadImportanceButton.setToolTipText("Load importance file...");
        this.attributesImportance = null;
        this.connectionWeightSlider.init();
        this.setConnectionWeight(0.0f, true);
        this.topSetSizeSlider.init();
        this.setTopRankingSize(0, true);
    }

    private void initSaveBitampFileDialog() {
        this.saveBitmapFileDialog = new JFileChooser(ExperimentParams.DEFAULT_RES_PATH);
        this.saveBitmapFileDialog.setLocation(100, 100);
        ComplexFileFilter[] fileFilters = new ComplexFileFilter[]{new ComplexFileFilter(new String[]{"jpg"}, "jpg bitmap"), new ComplexFileFilter(new String[]{"png"}, "png bitmap")};
        int i = 0;
        while (i < 2) {
            this.saveBitmapFileDialog.addChoosableFileFilter(fileFilters[i]);
            ++i;
        }
    }

    private void initFileDialog() {
        this.fileDialog = new JFileChooser(ExperimentParams.DEFAULT_RES_PATH);
        this.fileDialog.setLocation(100, 100);
        ComplexFileFilter[] fileFilters = new ComplexFileFilter[]{new ComplexFileFilter(new String[]{"csv"}, "Comma Separated Histogram File")};
        int i = 0;
        while (i <= 0) {
            this.fileDialog.addChoosableFileFilter(fileFilters[0]);
            ++i;
        }
        this.fileDialog.addChoosableFileFilter(new ComplexFileFilter(new String[]{"csv"}, "All Supported Files"));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void actionPerformed(ActionEvent event) {
        void var1_1;
        Object eventObject = event.getSource();
        if (eventObject == this.loadImportanceButton) {
            int n;
            eventObject = this;
            if (((GraphViewerToolBar)eventObject).graphViever.connections.getNodesNumber() != 0 && (n = ((GraphViewerToolBar)eventObject).fileDialog.showOpenDialog((Component)eventObject)) != 1 && n == 0) {
                ((GraphViewerToolBar)eventObject).loadImportanceFile(((GraphViewerToolBar)eventObject).fileDialog.getSelectedFile());
            }
            return;
        }
        if (eventObject == this.drawButton) {
            this.graphViever.drawGraph();
            return;
        }
        if (eventObject == this.saveBitmapButton) {
            eventObject = this;
            ((GraphViewerToolBar)eventObject).saveBitmapFileDialog.setSelectedFile(new File("_n" + ((GraphViewerToolBar)eventObject).topSetSizeLabel.getText() + "_w" + ((GraphViewerToolBar)eventObject).connectionWeightLabel.getText() + ".png"));
            int n = ((GraphViewerToolBar)eventObject).saveBitmapFileDialog.showSaveDialog((Component)eventObject);
            boolean bl = false;
            if (n != 1 && n == 0) {
                File file = ((GraphViewerToolBar)eventObject).saveBitmapFileDialog.getSelectedFile();
                BufferedImage bufferedImage = ((GraphViewerToolBar)eventObject).graphViever.graphVisualization.getImage();
                if (((ComplexFileFilter)((GraphViewerToolBar)eventObject).saveBitmapFileDialog.getFileFilter()).accept("png")) {
                    bl = GraphViewerToolBar.saveBitmap("png", bufferedImage, file);
                } else if (((ComplexFileFilter)((GraphViewerToolBar)eventObject).saveBitmapFileDialog.getFileFilter()).accept("jpg")) {
                    bl = GraphViewerToolBar.saveBitmap("jpg", bufferedImage, file);
                }
                if (bl) {
                    System.out.println("File is saved.");
                }
            }
            return;
        }
        if (eventObject == this.topSetSizeLabel && this.isImportanceLoaded()) {
            this.topSetSizeSlider.setScaledValue(this.getTopSetSize());
            return;
        }
        if (var1_1 == this.connectionWeightLabel) {
            this.connectionWeightSlider.setScaledValue(this.getConnectionWeight());
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void stateChanged(ChangeEvent event) {
        void var1_1;
        Object eventObject = event.getSource();
        if (eventObject == this.connectionWeightSlider) {
            this.setConnectionWeight(this.connectionWeightSlider.getScaledValue(), false);
            if (this.instantRedrawCheckBox.isSelected()) {
                this.graphViever.drawGraph();
                return;
            }
        } else if (var1_1 == this.topSetSizeSlider && this.isImportanceLoaded()) {
            this.setTopRankingSize((int)this.topSetSizeSlider.getScaledValue(), false);
            if (this.instantRedrawCheckBox.isSelected()) {
                this.graphViever.drawGraph();
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void setConnectionWeight(float weight, boolean toSlider) {
        void var2_2;
        DecimalFormat decimalFormat = new DecimalFormat("0.0");
        String weightFormatted = decimalFormat.format(weight);
        this.connectionWeightLabel.setText((String)((Object)decimalFormat));
        if (var2_2 != false) {
            void var1_1;
            this.connectionWeightSlider.setScaledValue((float)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final float getConnectionWeight() {
        void var1_2;
        float weight;
        String text = this.connectionWeightLabel.getText();
        try {
            weight = Float.parseFloat(text);
        }
        catch (NumberFormatException numberFormatException) {
            weight = this.connectionWeightSlider.getScaledMinimum();
        }
        if (weight < this.connectionWeightSlider.getScaledMinimum() || weight > this.connectionWeightSlider.getScaledMaximum()) {
            weight = this.connectionWeightSlider.getScaledMinimum();
        }
        return (float)var1_2;
    }

    /*
     * WARNING - void declaration
     */
    public final void setTopRankingSize(int size, boolean toSlider) {
        void var2_2;
        this.topSetSizeLabel.setText(Integer.toString(size));
        if (var2_2 != false) {
            void var1_1;
            this.topSetSizeSlider.setScaledValue((float)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final int getTopSetSize() {
        void var1_2;
        int size;
        String text = this.topSetSizeLabel.getText();
        try {
            size = Integer.parseInt(text);
        }
        catch (NumberFormatException numberFormatException) {
            size = (int)this.topSetSizeSlider.getScaledMaximum();
        }
        if (size < 0 || size > (int)this.topSetSizeSlider.getScaledMaximum()) {
            size = (int)this.topSetSizeSlider.getScaledMaximum();
        }
        return (int)var1_2;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean loadImportanceFile(File file) {
        void var1_1;
        this.attributesImportance = new AttributesRI();
        if (!this.attributesImportance.load(file.getAbsolutePath())) {
            this.attributesImportance = null;
            return false;
        }
        this.loadImportanceButton.setToolTipText(var1_1.getName());
        return true;
    }

    public final boolean isImportanceLoaded() {
        return this.attributesImportance != null;
    }

    /*
     * WARNING - void declaration
     */
    public final void initWeightSlider(AttributesID connections) {
        void var1_1;
        if (connections == null || connections.getNodesNumber() == 0) {
            this.connectionWeightSlider.init();
            return;
        }
        this.connectionWeightSlider.init(0.0f, var1_1.getMaxID(), 0.0f, 0.1f);
    }

    /*
     * WARNING - void declaration
     */
    public final void initTopSetSlider(AttributesID connections) {
        if (connections == null || connections.getNodesNumber() == 0) {
            this.topSetSizeSlider.init();
            return;
        }
        if (this.isImportanceLoaded()) {
            void var1_2;
            int maxSliderValue = this.attributesImportance.getAttributesNumber();
            if (maxSliderValue > GraphViewerBody.TOP_SET_MAX_SLIDER_VALUE) {
                maxSliderValue = GraphViewerBody.TOP_SET_MAX_SLIDER_VALUE;
            }
            this.topSetSizeSlider.init(0.0f, (float)var1_2, 1.0f, 1.0f);
            return;
        }
        this.topSetSizeSlider.init();
    }

    public final AttributesRI getAttributesImportance() {
        return this.attributesImportance;
    }

    /*
     * WARNING - void declaration
     */
    private static boolean saveBitmap(String format, BufferedImage image, File file) {
        void var2_2;
        String filePath = file.getAbsolutePath();
        if (!DiscFunctions.getFileExtension(var2_2.getName()).equalsIgnoreCase(format)) {
            filePath = String.valueOf(filePath) + "." + format;
        }
        System.out.println("Saving: " + filePath);
        try {
            String string;
            void var1_1;
            ImageIO.write((RenderedImage)var1_1, string, new File(filePath));
        }
        catch (IOException iOException) {
            void var3_3;
            System.err.println("Error saving the file. File: " + (String)var3_3);
            return false;
        }
        return true;
    }
}

