/*
 * Decompiled with CFR 0.152.
 */
package dmLab.classifier;

import dmLab.array.functions.DiscFunctions;
import dmLab.classifier.Classifier;
import dmLab.classifier.Prediction;
import dmLab.utils.cmatrix.ConfusionMatrix;
import dmLab.utils.cmatrix.QualityMeasure;

public final class PredictionResult {
    public ConfusionMatrix confusionMatrix;
    public Prediction[] predictions;
    private int type;

    /*
     * WARNING - void declaration
     */
    public PredictionResult(int type) {
        void var1_1;
        this.type = var1_1;
    }

    public final double getPredQuality() {
        if (this.type == Classifier.MODEL_CLASSIFIER) {
            return this.getPredQuality(QualityMeasure.WACC);
        }
        if (this.type == Classifier.MODEL_PREDICTOR) {
            return this.getPredQuality(QualityMeasure.PEARSON);
        }
        return Double.NaN;
    }

    /*
     * WARNING - void declaration
     */
    public final double getPredQuality(int measure22) {
        void var1_1;
        int measure22;
        if (this.type == Classifier.MODEL_CLASSIFIER) {
            if (measure22 == QualityMeasure.WACC) {
                return QualityMeasure.calcWAcc(this.confusionMatrix.getMatrix());
            }
            if (measure22 == QualityMeasure.ACC) {
                return QualityMeasure.calcAcc(this.confusionMatrix.getMatrix());
            }
            return Double.NaN;
        }
        double[] x = new double[this.predictions.length];
        double[] y2 = new double[this.predictions.length];
        int i = 0;
        while (i < x.length) {
            x[i] = this.predictions[i].getRealValue();
            y2[i] = this.predictions[i].getPredictedValue();
            ++i;
        }
        if (measure22 == QualityMeasure.PEARSON) {
            return DiscFunctions.pearson(x, y2);
        }
        if (measure22 == QualityMeasure.MAE) {
            float f;
            double[] dArray = x;
            x = y2;
            double[] measure22 = dArray;
            if (dArray.length != x.length) {
                f = Float.NaN;
            } else {
                double d = 0.0;
                int y2 = 0;
                while (y2 < measure22.length) {
                    d += Math.abs(measure22[y2] - x[y2]);
                    ++y2;
                }
                f = (float)(d /= (double)measure22.length);
            }
            return f;
        }
        if (measure22 == QualityMeasure.RMSE) {
            float f;
            double[] dArray = x;
            x = y2;
            double[] measure22 = dArray;
            if (dArray.length != x.length) {
                f = Float.NaN;
            } else {
                double d = 0.0;
                int y2 = 0;
                while (y2 < measure22.length) {
                    d += Math.pow(measure22[y2] - x[y2], 2.0);
                    ++y2;
                }
                d = Math.sqrt(d / (double)measure22.length);
                f = (float)d;
            }
            return f;
        }
        if (var1_1 == QualityMeasure.SMAPE) {
            float f;
            void var3_6;
            void var2_5;
            void v4 = var2_5;
            var2_5 = var3_6;
            void var1_4 = v4;
            if (((void)v4).length != ((void)var2_5).length) {
                f = Float.NaN;
            } else {
                double d = 0.0;
                int n = 0;
                while (n < ((void)var1_4).length) {
                    d += Math.abs((double)(var1_4[n] - var2_5[n])) / (Math.abs((double)var1_4[n]) + Math.abs((double)var2_5[n]));
                    ++n;
                }
                f = (float)(d /= (double)((void)var1_4).length);
            }
            return f;
        }
        return Double.NaN;
    }

    /*
     * WARNING - void declaration
     */
    public final String toString() {
        if (this.type == Classifier.MODEL_PREDICTOR && this.predictions != null) {
            StringBuffer tmp = new StringBuffer();
            tmp.append("Pearson Correlation: " + this.getPredQuality(QualityMeasure.PEARSON)).append("\n");
            tmp.append("MAE: " + this.getPredQuality(QualityMeasure.MAE)).append("\n");
            tmp.append("RMSE: " + this.getPredQuality(QualityMeasure.RMSE)).append("\n");
            tmp.append("SMAPE: " + this.getPredQuality(QualityMeasure.SMAPE)).append("\n");
            return tmp.toString();
        }
        if (this.type == Classifier.MODEL_CLASSIFIER && this.confusionMatrix != null) {
            void var1_2;
            StringBuffer tmp = new StringBuffer();
            tmp.append(this.confusionMatrix.toString(true, true, false, "\t"));
            tmp.append(this.confusionMatrix.statsToString(4));
            return var1_2.toString();
        }
        return "";
    }
}

