/*
 * Decompiled with CFR 0.152.
 */
package dmLab.gui.dataEditor.dbConnector;

import com.microsoft.sqlserver.jdbc.SQLServerDriver;
import com.mysql.jdbc.Driver;
import dmLab.gui.dataEditor.dbConnector.DBProps;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import oracle.jdbc.driver.OracleDriver;

public final class DBConnector {
    private Connection connection;
    private Statement stmtQuery;
    private ResultSet rs;
    private int dbType;
    private static int ORACLE = 0;
    private static int POSTGRES = 1;
    public static int MYSQL = 2;
    private static int MSSQL = 3;
    public static String[] DB_CFG_FILE_NAME = new String[]{"db_oracle.cfg", "db_postgres.cfg", "db_mysql.cfg", "db_mssql.cfg"};

    /*
     * WARNING - void declaration
     */
    public final boolean connect(DBProps dbProps) {
        try {
            this.dbType = dbProps.DBType;
            if (this.dbType == 0) {
                DriverManager.registerDriver((java.sql.Driver)new OracleDriver());
                String connString = "jdbc:oracle:thin:" + dbProps.host + ":" + dbProps.dbName;
                this.connection = DriverManager.getConnection(connString, dbProps.user, dbProps.password);
            } else if (this.dbType == POSTGRES) {
                DriverManager.registerDriver((java.sql.Driver)new org.postgresql.Driver());
                String connString = "jdbc:postgresql://" + dbProps.host + "/" + dbProps.dbName;
                connString = String.valueOf(connString) + "?user=" + dbProps.user + "?password=" + dbProps.password;
                this.connection = DriverManager.getConnection(connString);
            } else if (this.dbType == MYSQL) {
                DriverManager.registerDriver((java.sql.Driver)new Driver());
                String connString = "jdbc:mysql://" + dbProps.host + "/" + dbProps.dbName;
                connString = String.valueOf(connString) + "?user=" + dbProps.user + "&password=" + dbProps.password;
                connString = String.valueOf(connString) + "&useUnicode=true&characterEncoding=" + dbProps.encoding + "&characterSetResults=" + dbProps.encoding;
                this.connection = DriverManager.getConnection(connString);
            } else if (this.dbType == MSSQL) {
                void var2_6;
                DriverManager.registerDriver((java.sql.Driver)new SQLServerDriver());
                String connString = "jdbc:sqlserver://" + dbProps.host + ";DatabaseName=" + dbProps.dbName;
                this.connection = DriverManager.getConnection((String)var2_6, dbProps.user, dbProps.password);
            }
            this.connection.createStatement();
            this.stmtQuery = this.connection.createStatement(1004, 1007);
        }
        catch (Exception error) {
            void var1_2;
            System.err.println("Conection Failed!");
            var1_2.printStackTrace();
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public final ResultSet executeQuery(String mySQLquery) {
        try {
            this.rs = this.stmtQuery.executeQuery(mySQLquery);
        }
        catch (SQLException error) {
            void var2_2;
            void var1_1;
            System.err.println("Error in query! Query: " + (String)var1_1);
            var2_2.printStackTrace();
            return null;
        }
        return this.rs;
    }
}

