% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Expression.R
\name{Comprehension}
\alias{Comprehension}
\title{Comprehension}
\description{
Create a Comprehension in MiniZinc
}
\section{Super class}{
\code{\link[rminizinc:Expression]{rminizinc::Expression}} -> \code{Comprehension}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{.generators}}{a vector of generators}

\item{\code{.expression}}{the comprehension expression}

\item{\code{.set}}{TRUE if comprehension is a set}

\item{\code{.delete_flag}}{used to delete items}
}
\if{html}{\out{</div>}}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{.generators}}{a vector of generators}

\item{\code{.expression}}{the comprehension expression}

\item{\code{.set}}{TRUE if comprehension is a set}

\item{\code{.delete_flag}}{used to delete items}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{Comprehension$new()}}
\item \href{#method-ngens}{\code{Comprehension$ngens()}}
\item \href{#method-getGens}{\code{Comprehension$getGens()}}
\item \href{#method-setGens}{\code{Comprehension$setGens()}}
\item \href{#method-getGen}{\code{Comprehension$getGen()}}
\item \href{#method-setGen}{\code{Comprehension$setGen()}}
\item \href{#method-getBody}{\code{Comprehension$getBody()}}
\item \href{#method-setBody}{\code{Comprehension$setBody()}}
\item \href{#method-isSet}{\code{Comprehension$isSet()}}
\item \href{#method-c_str}{\code{Comprehension$c_str()}}
\item \href{#method-getDeleteFlag}{\code{Comprehension$getDeleteFlag()}}
\item \href{#method-delete}{\code{Comprehension$delete()}}
\item \href{#method-clone}{\code{Comprehension$clone()}}
}
}
\if{html}{
\out{<details open ><summary>Inherited methods</summary>}
\itemize{
}
\out{</details>}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
constructor
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Comprehension$new(generators, body, set)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{generators}}{generators of the expression}

\item{\code{body}}{body/expression of the comprehension}

\item{\code{set}}{bool to specify if comprehension is a set.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ngens"></a>}}
\if{latex}{\out{\hypertarget{method-ngens}{}}}
\subsection{Method \code{ngens()}}{
get the number of generators
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Comprehension$ngens()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-getGens"></a>}}
\if{latex}{\out{\hypertarget{method-getGens}{}}}
\subsection{Method \code{getGens()}}{
get all the generator expressions
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Comprehension$getGens()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-setGens"></a>}}
\if{latex}{\out{\hypertarget{method-setGens}{}}}
\subsection{Method \code{setGens()}}{
set all the generator expressions
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Comprehension$setGens(generators)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{generators}}{list of generator expressions to be set}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-getGen"></a>}}
\if{latex}{\out{\hypertarget{method-getGen}{}}}
\subsection{Method \code{getGen()}}{
get the ith generator expression
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Comprehension$getGen(i)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{i}}{index}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-setGen"></a>}}
\if{latex}{\out{\hypertarget{method-setGen}{}}}
\subsection{Method \code{setGen()}}{
set the ith generator expression
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Comprehension$setGen(i, expGen)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{i}}{index}

\item{\code{expGen}}{generator expression to be set}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-getBody"></a>}}
\if{latex}{\out{\hypertarget{method-getBody}{}}}
\subsection{Method \code{getBody()}}{
get the expression/body
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Comprehension$getBody()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-setBody"></a>}}
\if{latex}{\out{\hypertarget{method-setBody}{}}}
\subsection{Method \code{setBody()}}{
set the expression/body
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Comprehension$setBody(e)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{e}}{new expression value}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-isSet"></a>}}
\if{latex}{\out{\hypertarget{method-isSet}{}}}
\subsection{Method \code{isSet()}}{
check if comprehension is a set
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Comprehension$isSet()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-c_str"></a>}}
\if{latex}{\out{\hypertarget{method-c_str}{}}}
\subsection{Method \code{c_str()}}{
get the MiniZinc representation
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Comprehension$c_str()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-getDeleteFlag"></a>}}
\if{latex}{\out{\hypertarget{method-getDeleteFlag}{}}}
\subsection{Method \code{getDeleteFlag()}}{
delete flag for internal use
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Comprehension$getDeleteFlag()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-delete"></a>}}
\if{latex}{\out{\hypertarget{method-delete}{}}}
\subsection{Method \code{delete()}}{
delete the assignment item
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Comprehension$delete()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Comprehension$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
