/* Copyright 2004,2007,2010,2018 IPB, Universite de Bordeaux, INRIA & CNRS
**
** This file is part of the Scotch software package for static mapping,
** graph partitioning and sparse matrix ordering.
**
** This software is governed by the CeCILL-C license under French law
** and abiding by the rules of distribution of free software. You can
** use, modify and/or redistribute the software under the terms of the
** CeCILL-C license as circulated by CEA, CNRS and INRIA at the following
** URL: "http://www.cecill.info".
** 
** As a counterpart to the access to the source code and rights to copy,
** modify and redistribute granted by the license, users are provided
** only with a limited warranty and the software's author, the holder of
** the economic rights, and the successive licensors have only limited
** liability.
** 
** In this respect, the user's attention is drawn to the risks associated
** with loading, using, modifying and/or developing or reproducing the
** software by the user in light of its specific status of free software,
** that may mean that it is complicated to manipulate, and that also
** therefore means that it is reserved for developers and experienced
** professionals having in-depth computer knowledge. Users are therefore
** encouraged to load and test the software's suitability as regards
** their requirements in conditions enabling the security of their
** systems and/or data to be ensured and, more generally, to use and
** operate it in the same conditions as regards security.
** 
** The fact that you are presently reading this means that you have had
** knowledge of the CeCILL-C license and that you accept its terms.
*/
/************************************************************/
/**                                                        **/
/**   NAME       : bgraph_bipart_gp.h                      **/
/**                                                        **/
/**   AUTHOR     : Francois PELLEGRINI                     **/
/**                                                        **/
/**   FUNCTION   : These lines are the data declaration    **/
/**                for the Gibbs, Poole, and Stockmeyer    **/
/**                bipartitioning algorithm.               **/
/**                                                        **/
/**   DATES      : # Version 2.0  : from : 06 jun 1994     **/
/**                                 to     28 oct 1994     **/
/**                # Version 3.2  : from : 21 sep 1996     **/
/**                                 to     13 sep 1998     **/
/**                # Version 3.3  : from : 01 oct 1998     **/
/**                                 to     01 oct 1998     **/
/**                # Version 4.0  : from : 01 nov 2003     **/
/**                                 to     20 aug 2004     **/
/**                # Version 5.1  : from : 04 nov 2010     **/
/**                                 to     04 nov 2010     **/
/**                # Version 6.0  : from : 05 apr 2018     **/
/**                                 to     05 apr 2018     **/
/**                                                        **/
/************************************************************/

/*
**  The type and structure definitions.
*/

/*+ Method parameters. +*/

typedef struct BgraphBipartGpParam_ {
  INT                       passnbr;              /*+ Number of passes to do +*/
} BgraphBipartGpParam;

/*+ Complementary vertex structure. +*/

typedef struct BgraphBipartGpVertex_ {
  Gnum                      passnum;              /*+ Number of pass when vertex selected   +*/
  Gnum                      distval;              /*+ Current distance from diameter vertex +*/
} BgraphBipartGpVertex;

/*+ Neighbor queue. +*/

typedef struct BgraphBipartGpQueue_ {
  Gnum                      headnum;              /*+ Head of distance queue  +*/
  Gnum                      tailnum;              /*+ Tail of distance queue  +*/
  Gnum *                    queutab;              /*+ Array of queue elements +*/
} BgraphBipartGpQueue;

/*
**  The function prototypes.
*/

int                         bgraphBipartGp      (Bgraph * restrict const, const BgraphBipartGpParam * const);

/*
**  The macro definitions.
*/

#define bgraphBipartGpQueueFlush(queue) ((queue)->headnum = (queue)->tailnum = 0)
#define bgraphBipartGpQueueEmpty(queue) ((queue)->headnum <= (queue)->tailnum)
#define bgraphBipartGpQueuePut(queue,vnum) ((queue)->queutab[(queue)->headnum ++] = (vnum))
#define bgraphBipartGpQueueGet(queue) ((queue)->queutab[(queue)->tailnum ++])
